/*
typedef struct genConfig
{
	BOOL browseInfo;
	BOOL completionEnabled;
	BOOL parenthesisCheck;
	LOGFONT EditFont;
	int editFlags;
	int findFlags;
	int replaceFlags;
	int tabs;
	COLORREF keywordColor;
	COLORREF commentColor;
	COLORREF numberColor;
	COLORREF stringColor;
	COLORREF escapeColor;
	COLORREF backgroundColor;
	COLORREF textColor;
	COLORREF highlightColor;
	COLORREF custColors[16];
	int memoryWordSize;
	char printHeader[256];
	char printFooter[256];
	int leftMargin;
	int rightMargin;
	int topMargin;
	int bottomMargin;
	char szHelpPath[256];
	char *findhist[MAX_COMBO_HISTORY];
	char *fifdirhist[MAX_COMBO_HISTORY];
	char *replacehist[MAX_COMBO_HISTORY];
	char *watchhist[MAX_COMBO_HISTORY];
	char *memhist[MAX_COMBO_HISTORY];
	DWINFO *mrulist[MAX_MRU];

} GENCONFIG;
*/
typedef struct projConfig
{
	struct projConfig *next;
    char outputPath[1024];
    char includePath[1024];
    char libPath[1024];
	PROJDEPS *projectDeps;
    DEFINES *defines;
    enum
    {
        BT_CONSOLE, BT_WINDOWS, BT_DLL, BT_LIBRARY, BT_DOS, BT_RAW
    } buildType;
    enum
    {
        LT_STANDARD, LT_LSCRTDLL, LT_NONE, LT_CRTDLL, LT_MSVCRT
    } libType;
    unsigned buildFlags;
	unsigned defineFlags;
    char cmdline[1024];
    char compileopts[1024];
    char assembleopts[1024];
    char linkopts[1024];
    char libopts[1024];
    char prebuildlabel[81];
    char postbuildlabel[81];
    char prebuildsteps[1024];
    char postbuildsteps[1024];
} PROJCONFIG;
GENCONFIG defaultConfig =
{
int custColors[16];
LOGFONT defaultFont = 
	{
	     - 16, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, ANSI_CHARSET,
	         OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, FIXED_PITCH 
	         | FF_DONTCARE, "Courier New"
	};
{ b_bool, CPID_BROWSEINFO, { (void *)FALSE } },
{ b_bool, CPID_COMPLETION, { (void *)TRUE } },
{ b_bool, CPID_SHOWPAREN, { (void *)TRUE } },
{ b_pointer, CPID_LOGFONT, { (void *)defaultFont, (void *)sizeof(defaultFont) } },
{ b_bool, CPID_BACKUP_FILES, { (void *)TRUE } },
{ b_bool, CPID_BACKUP_PROJECTS, { (void *)TRUE } },
{ b_bool, CPID_TABS_AS_SPACES, { (void *)FALSE } },
{ b_bool, CPID_AUTO_INDENT, { (void *)TRUE } },
{ b_bool, CPID_AUTO_FORMAT, { (void *)TRUE } },
{ b_int, CPID_TABSPACING, { (void *)4 } },
{ b_colorref, CPID_COLOR_KEYWORD, { (void *) 0xff8000 } },
{ b_colorref, CPID_COLOR_COMMENT, { (void *) 0x00C000 } },
{ b_colorref, CPID_COLOR_NUMBER, { (void *) 0x0000FF } },
{ b_colorref, CPID_COLOR_STRING, { (void *) 0x8000FF } },
{ b_colorref, CPID_COLOR_ESCAPE, { (void *) 0xFF0000 } },
{ b_colorref, CPID_COLOR_BACKGROUND, { (void *) 0xFFFFFF } },
{ b_colorref, CPID_COLOR_TEXT, { (void *) 0x000000 } },
{ b_colorref, CPID_COLOR_HIGHLIGHT, { (void *) 0x80FFFF } },
{ b_pointer, CPID_CUSTOM_COLORS, { (void *)custColors, (void *)sizeof(custColors) } },
{ b_int, CPID_MEMORYWORDSIZE, { (void *)1 } },
{ b_string, CPID_PRINT_HEADER, { {void *) "%F" } },
{ b_string, CPID_PRINT_FOOTER, { {void *) "%P of %#" } },
{ b_string, CPID_HELP_PATH, { {void *) "" } },
{ b_int, CPID_LEFTMARGIN, { { void *)10 } },
{ b_int, CPID_RIGHTMARGIN, { { void *)10 } },
{ b_int, CPID_TOPMARGIN, { { void *)10 } },
{ b_int, CPID_BOTTOMMARGIN, { { void *)10 } },
} ;
typedef struct configdata
{
	enum { p_none, p_bool, p_combo, p_int, p_string, p_history, p_colorref } type;
	int PID;
	BOOL inherit;
	union
	{
		void *data[4]; /* update for max size */
		struct _p_bool
		{
			BOOL value;
		} b ;
		struct _p_combo
		{
			int min;
			int max;
			char **strings;
			BOOL value;
		} c ;
		struct _p_int
		{
			int min;
			int max;
			int value;
		} i;
		struct _p_string
		{
			char *string;
		} s;
		struct _p_hist
		{
			struct _p_hist *next;
			char *data;
		} h;
		struct _p_colorref
		{
			COLORREF value;
		} cr;
	} ;
} CONFIGDATA;

typedef struct configpage
{
	struct configpage *next;
	struct configpage *child;
	CONFIGDATA *config;
	char *name;
} CONFIGPAGE;
