/* 
CCIDE
Copyright 2001-2006 David Lindauer.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

You may contact the author at:
	mailto::camille@bluegrass.net
 */


#include "winconst.h"
#include "lsctrl.h"
#include "progress.h"

#pragma pack(1)

#ifdef BORLANDC
    #define LLONG_TYPE long 
#else 
    #define LLONG_TYPE long long
#endif 
#define MAX_COMBO_HISTORY 10

#define HBREAK 

#define DID_TABWND 1
#define DID_WATCHWND 2
#define DID_ERRORWND 3
#define DID_ASMWND 4
#define DID_MEMWND 5
#define DID_STACKWND 6
#define DID_THREADWND 7
#define DID_BPWND 8
#define DID_REGWND 9

#define DID_EDITTOOL 20
#define DID_BUILDTOOL 21
#define DID_DEBUGTOOL 22

#define TAG_BP 0
#define TAG_FIF1 1
#define TAG_FIF2 2
#define TAG_BOOKMARK 3
#define TAG_BPGRAYED 4 /* no tags gathered here, this is just a return value */
#define TAG_MAX 5

#define TAGM_SAVEFILE 0
#define TAGM_DISCARDFILE 1
#define TAGM_UPDATEDEBUG 2

#define TAGF_ENABLED 1
#define TAGF_GRAYED 2

#define BACKUP_FILES 1
#define BACKUP_PROJECTS 2
#define TABS_AS_SPACES 4
#define AUTO_INDENT 8   /* negative setting for backward compatibility */
#define AUTO_FORMAT 16

#define HELP_MSDN 0
#define HELP_SDK 1
#define HELP_SPECIFIED 2

#define ERR_BUILD_WINDOW 0
#define ERR_DEBUG_WINDOW 1
#define ERR_FIND1_WINDOW 2
#define ERR_FIND2_WINDOW 3

#define COLORIZE_NONE 0
#define COLORIZE_C 1
#define COLORIZE_ASM 2

#define EDITSIG 0xf1823794

typedef struct dwinfo
{
    char dwTitle[260];
    char dwName[260];
    HWND dwHandle;
    HWND self;
    int dwLineNo;
    int logMRU: 1;
    int newFile : 1;
    FILETIME time;
} DWINFO;

typedef struct dependslist
{
    struct dependslist *next;
    struct projlist *parent;
    char name[280];
    char title[280];
    HTREEITEM treeHandle;
    FILETIME timex;
    int rebuild: 1;
    int gottime: 1;
} DEPENDSLIST;
typedef struct filelist
{
    struct filelist *next;
    struct projlist *parent;
    char name[256];
    char title[256];
    char output[256];
    HTREEITEM treeHandle;
    DEPENDSLIST *depends;
    FILETIME timex;
    FILETIME outputTimex;
    int rebuild: 1;
} FILELIST;

#define DEFINE_TONASM 1

typedef struct defines
{
    struct defines *next;
    char name[256];
    char value[256];
} DEFINES;

#define BF_DEBUGINFO  1
#define BF_MAPFILE    2
#define BF_COMPILEVIAASM 4
#define BF_CRTDLL 8 /* obsolete */
#define BF_BROWSEINFO 16
#define BF_SHOWWARNINGS 32
#define BF_C99 64
#define BF_ANSI 128
#define BF_SHOWRETURNCODE 0x10000
#define BF_BREAKDLL 0x20000
#define BF_DEBUGEXCEPTION 0x40000
#define BF_DEBUGTOOLTIPS 0x80000
#define BF_HWBP 0x100000
#define BF_CHANGEDTARGET 0x40000000
#define BF_ALIGNSTACK    0x80000000

#define TFO_MAIN 1
#define TFO_SOURCE 2
#define TFO_INCLUDE 4
#define TFO_RESOURCE 8
#define TFO_OTHER 16

typedef struct projdeps
{
        struct projdeps * next;
        struct projlist *proj;
} PROJDEPS;

typedef struct projlist
{
    struct projlist *next;
    char name[256];
    char title[256];
    char projectName[256];
    char outputPath[1024];
    char includePath[1024];
	PROJDEPS *projdeps;
    FILELIST *sourceFiles, *resourceFiles, *otherFiles;
    DEFINES *defines;
    HTREEITEM treeHandle;
    HTREEITEM sourceTreeHandle, includeTreeHandle, resourceTreeHandle, otherTreeHandle;
    FILETIME timex;
    enum
    {
        BT_CONSOLE, BT_WINDOWS, BT_DLL, BT_LIBRARY, BT_DOS, BT_RAW
    } buildType;
    enum
    {
        LT_STANDARD, LT_LSCRTDLL, LT_NONE, LT_CRTDLL, LT_MSVCRT
    } libType;
    unsigned buildFlags;
	unsigned defineFlags;
    unsigned treeOpenFlags;
    unsigned dbgview;
    int rebuild: 1;
    int changed: 1;
    char cmdline[1024];
    char compileopts[1024];
    char assembleopts[1024];
    char linkopts[1024];
    char libopts[1024];
    char prebuildlabel[81];
    char postbuildlabel[81];
    char prebuildsteps[1024];
    char postbuildsteps[1024];
    char bkNames[4][256];
    unsigned char bkModes[4], bkSizes[4];
}

//-------------------------------------------------------------------------

PROJLIST;

typedef struct treedata
{
    enum td_type { treeFile, treeDepend, treeProject, treeWorkspace } t_type;
    union {
        void *data;
        PROJLIST *project;
        FILELIST *file;
        DEPENDSLIST *depend;
    } x ;
} TREEDATA;

typedef struct
{
    int id;
    char *text;
} POPUPMENUTEXT;

typedef struct
{
    int start, end;
    int color;
    int italic;
} EDITATTRIBS;

typedef struct _bkpt
{
    struct _bkpt *next;
    int address;
    unsigned char tempVal;
    int active;
    int linenum;
    void *extra; // to be defined later
    char module[256];
} BREAKPOINT;

typedef struct _threads
{
    struct _threads *next;
    CONTEXT regs; // keep this first, it has to be DWORD aligned
    // malloc will always return DWORD alignment so we are safe
    HANDLE hThread;
    DWORD idThread;
    DWORD oldaddr;
    DWORD suspcount;
    BREAKPOINT breakpoint;
    char name[256];
} THREAD;

typedef struct dbg_info
{
    unsigned char *info;
    int size;
    int base;
} DEBUG_INFO;

typedef struct dll_info
{
    struct dll_info *next;
    DEBUG_INFO *dbg_info;
    int base;
    char name[512];
    int fUnicode;
    int breakpoint;
    HANDLE hFile;
} DLL_INFO;

typedef struct
{
    HANDLE hProcess;
    DWORD idProcess;
    THREAD *threads;
    BREAKPOINT breakpoints;
    int idTempBpThread;
    DEBUG_INFO *dbg_info;
    DLL_INFO *dll_info;
    int ExitAddr;
} PROCESS;
enum DebugState
{
    notDebugging, SteppingOut, SteppingOver, SteppingIn, StepInOut,
        FinishStepOut, Running, atBreakpoint, atException, Aborting, nullState
};

typedef struct varinfo
{
    TCData watchhead;
    HTREEITEM hTreeItem, hTreeHolder;
    THREAD *thread;
    struct varinfo *subtype; /* for substructures */
    struct varinfo *link; /* for next link in structure */
    char *typetab;
    int type;
	int enumfield;
    int address;
	int derefaddress;
    int offset;
    long double fval,fvali;
    LLONG_TYPE ival;
    int outofscopereg: 1;
    int constant: 1;
    int pointer: 1;
    int enumx: 1;
    int structure: 1;
    int unionx: 1;
    int bitfield: 1;
    int array: 1;
    int bitstart: 5;
    int bitlength: 5;
    int outofscope: 1;
    int editable: 1;
    int udt: 1;
    int explicitreg: 1;
    int inreg: 1;
    int vararray: 1;
	int argument : 1;
    int arraysize;
    int itemsize;
    int vararraylevel;
    int *vararraylist;
    int *vararraylisttofree;
    int watchindex;
    char membername[256];
    char structtag[256];
    char value[256];
    char screenname[256];
} VARINFO;

typedef struct
{
    VARINFO *info;
    char *typetab;
    char *symtab;
    DEBUG_INFO *dbg_info;
    int cursoreip;
} WATCHINFO;

struct tag
{
    struct tag *next;
    int drawnLineno;
    int editingLineno;
    int debugLineno;
    int fileLineno;
    int charpos;
    int enabled;
    void *extra;
};

struct tagchangeln
{
    struct tagchangeln *next;
    int lineno;
    int delta;
};
struct tagfile
{
    char *next;
    char name[256];
    struct tag *tagArray[TAG_MAX];
    struct tagchangeln *changedLines;
};
typedef struct
{
//    COLORREF color;
    short effect;
    char ch;
	unsigned char Color;
//    char pad;
} INTERNAL_CHAR;

#define CRLF_DUMMY 255

// The next few constants control the UNDO mechanism
#define UNDO_MAX 1000
#define UNDO_INSERT 1
#define UNDO_DELETE 2
#define UNDO_BACKSPACE 3
#define UNDO_MODIFY 4
#define UNDO_DELETESELECTION 5
#define UNDO_INSERTSELECTION 6
#define UNDO_CASECHANGE 7
#define UNDO_AUTOEND 8
#define UNDO_AUTOBEGIN 9
#define UNDO_AUTOCHAINBEGIN 10
#define UNDO_AUTOCHAINEND 11
// a list of UNDO structures describe each operation the user performs.
// The list is traversed backwards if 'undo' is pressed.
typedef struct
{
    int preselstart;
    int preselend;
    int postselstart;
    int postselend;
	int charpos;
    int len;
    int max;
    unsigned char *data;
	int undotemp;
    char type;
    char modified: 1;
} UNDO;

// the EDITDATA structure holds all information the edit control has
// available on a per window basis.  Note that this isn't all the information
// there is about the window; things that aren't related to editing
// may be held in structures in the EDITOR module
typedef struct
{
	struct _edlist_ *siblings ;
    HWND tooltip;
    RECT ttrect;
    char ttident[256];
    int ttlineno;
	unsigned char *lineData;
	int lineDataMax;
    HFONT hFont, hBoldFont, hItalicFont, hItalicBoldFont;
    HBRUSH hbrBackground;
    COLORREF defforeground;
    COLORREF defbackground;
    INTERNAL_CHAR *text;
	char highlightText[256];
    int textlen;
    int textmaxlen;
    int tabs;
    int leftmargin;
    int updowncol;
    UNDO undolist[UNDO_MAX];
    int undohead;
    int undotail;
	int redotop;
	UINT reparseTimerID;
    char undoing;
    char colorize;
    char modified;
    char txtFontHeight;
    char txtFontWidth;
    char nosel;
    char inserting;
    char selecting;
    char buttondown;
    char autoscrolldir;
    char ttup;
    char sendchangeonpaint;
    char readonly;
} COREDATA;

typedef struct {
	COREDATA *cd ;
	HWND self ;
	int id ;
    int selstartcharpos;
    int selendcharpos;
    int textshowncharpos;
    int leftshownindex;
	int matchingStart;
	int matchingEnd;
    char hasfocus;
    char hiddenCaret;
} EDITDATA ;

typedef struct _edlist_
{
	struct _list_ *next;
	EDITDATA *data;
} EDLIST;

#define EDIT_PROPERTY_SHEET_COUNT 4
#define EDITPROP 0
#define PRINTFORMATPROP 1
#define GENERALPROP 2
#define INSTALLPROP 3

#include "ccide.p"

#ifndef __CCDL__
    #ifndef LVS_EX_CHECKBOXES
        #define LVS_EX_CHECKBOXES 4
        #define LVM_FIRST 0x1000
        #define LVM_SETEXTENDEDLISTVIEWSTYLE (LVM_FIRST + 54)   
            // optional wParam == mask
        #define ListView_SetExtendedListViewStyle(hwndLV, dw)\
        (DWORD)SendMessage((hwndLV), LVM_SETEXTENDEDLISTVIEWSTYLE, 0, dw)
        #define ListView_SetCheckState(hwndLV, i, fCheck) \
        ListView_SetItemState(hwndLV, i, INDEXTOSTATEIMAGEMASK((fCheck)?2:1),LVIS_STATEIMAGEMASK)
        #define ListView_GetCheckState(hwndLV, i) \
        ((((UINT)(SendMessage((hwndLV), LVM_GETITEMSTATE, (WPARAM)(i),LVIS_STATEIMAGEMASK))) >> 12) -1)
        #define ListView_GetItemCount(hwnd) \
        (int)SendMessage ((hwnd), LVM_GETITEMCOUNT, 0, 0L)
        #define LVM_GETSELECTIONMARK    (LVM_FIRST + 66)
        #define ListView_GetSelectionMark(hwnd) \
        (int)SendMessage((hwnd), LVM_GETSELECTIONMARK, 0, 0)
    #endif 
    #ifndef _WIN32_IE
        typedef struct tagNMITEMACTIVATE
        {
            NMHDR hdr;
            int iItem;
            int iSubItem;
            UINT uNewState;
            UINT uOldState;
            UINT uChanged;
            POINT ptAction;
            LPARAM lParam;
            UINT uKeyFlags;
        } NMITEMACTIVATE, FAR *LPNMITEMACTIVATE;
    #endif 
    BOOL WINAPI IsDebuggerPresent();
#endif 
typedef struct minmax
{
    int min, max;
} charinfo;
#define STATUS_GUARD_PAGE_VIOLATION      ((DWORD   )0x80000001L)    
#define STATUS_INVALID_HANDLE            ((DWORD   )0xC0000008L)    
#define STATUS_FLOAT_MULTIPLE_FAULTS     ((DWORD   )0xC00002B4L)    
#define STATUS_FLOAT_MULTIPLE_TRAPS      ((DWORD   )0xC00002B5L)    
#define STATUS_ILLEGAL_VLM_REFERENCE     ((DWORD   )0xC00002C0L)     
#define STATUS_REG_NAT_CONSUMPTION       ((DWORD   )0xC00002C9L)
HRESULT WINAPI SHGetFolderPathA(HWND hwnd, int csidl, HANDLE hToken, DWORD dwFlags, LPSTR pszPath);
HRESULT WINAPI SHGetFolderPathW(HWND hwnd, int csidl, HANDLE hToken, DWORD dwFlags, LPWSTR pszPath);
#ifdef UNICODE
#define SHGetFolderPath  SHGetFolderPathW
#else
#define SHGetFolderPath  SHGetFolderPathA
#endif // !UNICODE
#define CSIDL_APPDATA 26

#ifndef OFN_DONTADDTORECENT
#define OFN_DONTADDTORECENT (33554432)
#endif

#ifdef XXXXX
#define free(x) my_free(x)
#define calloc(x,y) my_calloc(x,y)
#define malloc(x,y) my_malloc(x,y)
#define realloc(x,n) my_realloc(x,n)
#define strdup(s) my_strdup(s)
#endif

#pragma pack()