#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#define WINCRT_O_RDONLY GENERIC_READ
#define WINCRT_O_DENYWRITE FILE_SHARE_WRITE

inline HANDLE _openX(const char * filename,DWORD oflags,DWORD shflags) {
  return  CreateFileA(filename,oflags,shflags,NULL,OPEN_EXISTING,0,NULL);
}

inline BOOL _closeX(HANDLE hnd) {
  return CloseHandle(hnd);
}

DWORD _readXfn(HANDLE handle,LPVOID buf,DWORD len) {
  DWORD nr=0;
  ReadFile(handle,buf,len,&nr,NULL);
  return(nr);
}

inline DWORD _readXinline(HANDLE handle,LPVOID buf,DWORD len) {
  DWORD nr=0;
  printf("[inline==0x%x]",len); // WORD was supplied but a DWORD gets pushed
  ReadFile(handle,buf,len,&nr,NULL);
  return(nr); // the return value is demoted correctly or it would overwrite the bogus value in w3
}

void ladstest(void) {
  HANDLE fi=_openX("LADS.c",WINCRT_O_RDONLY,WINCRT_O_DENYWRITE);
  if (fi!=INVALID_HANDLE_VALUE) {
    char buf[8]; memset(buf,0xFF,sizeof(buf)); buf[sizeof(buf)-1]='\0';
    //printf("Expect %u %s says %u Received %s\n",sizeof(buf)-1,"inline",_readXinline(fi,buf,sizeof(buf)-1),buf);
    printf("Expect %u %s says %u Received %s\n",sizeof(buf)-1,"function",_readXfn(fi,buf,sizeof(buf)-1),buf);
    WORD w2,w3;
    memcpy(&w2,"\5",2); // This puts (WORD)5 into w2 without triggering register allocation or constant propogation
    w3=0; // this bogus value allows the first two iterations to succeed.
  	int i=-5;
  	do { // the 3rd iteration puts a non zero bogus value into w3 which makes the rest fail
      if (i==-3) memcpy(&w3,"\xFF\xFF",2); // a DWORD access of w2 will get these two bytes too
      w2=_readXinline(fi,buf,w2); if (w2<sizeof(buf)) buf[w2]='\0';
      printf("Expect %u %s says %u Received %s\n",5,"inline",w2,buf);
  	} while(++i);
    _closeX(fi);
  }
}

int __cdecl main(int argc,char *argv[]) {
  ladstest();
  return 0;
}
