/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <time.h>
#include <memory.h>
#include <errno.h>
#include <locale.h>
#include <wchar.h>
#include <io.h>
#include "libp.h"

extern FILE *_pstreams[_NFILE_];
extern int maxfiles;

/* so if they use a larger buf size in ascii mode, we are ignoring
 * it in terms of DPMI calls which may not be a good thing...
 */
#define LBSIZE 511

static char localbuf[LBSIZE];

static int __flushone(FILE *stream)
{
	int rv = 0, lvl;
	if (stream->token == FILTOK) {
        stream->flags &= ~_F_VBUF;
		if (stream->buffer)
			if (stream->flags & _F_OUT) {
				rv = write(fileno(stream),stream->buffer,stream->bsize + stream->level);
				if (rv < 0) {
					stream->flags |= _F_ERR;
					errno = ENOSPC;
					rv = EOF;
				}
				else rv = 0;
				if (eof(fileno(stream)))
					stream->flags |= _F_EOF;
				stream->level = 0;
			}
			else if (stream->flags & _F_READ) {
				if (stream->level > 0) {
					rv = lseek(fileno(stream),-stream->level+1,SEEK_CUR);
					if (rv < 0) {
						stream->flags |= _F_ERR;
						errno = ENOSPC;
						rv = EOF;
					}
					else
						rv = 0;
				}
				else rv = 0;
				memset(stream->buffer,0,stream->bsize);
				stream->level = 0;
			}
		stream->hold = 0;
		stream->curp = stream->buffer;
		stream->flags &= ~(_F_IN | _F_OUT | _F_UNGETC);
		return rv;			
	}
	else {
		errno = _dos_errno = ENOENT;
		return EOF;
   }
}
int _RTL_FUNC fflush(FILE *stream)
{
    int rv=0;
	if (stream) {
		return __flushone(stream);
    } else {
		int i;
		for (i=0; i < maxfiles; i++) {
			rv |= __flushone(_pstreams[i]);
        }
	}
	return rv;
}
int _RTL_FUNC flushall(void)
{
   fflush(0) ;
   return maxfiles -3 ;
}
