;Software License Agreement (BSD License)
;
;Copyright (c) 1997-2008, David Lindauer, (LADSoft).
;All rights reserved.
;
;Redistribution and use of this software in source and binary forms, with or without modification, are
;permitted provided that the following conditions are met:
;
;* Redistributions of source code must retain the above
;  copyright notice, this list of conditions and the
;  following disclaimer.
;
;* Redistributions in binary form must reproduce the above
;  copyright notice, this list of conditions and the
;  following disclaimer in the documentation and/or other
;  materials provided with the distribution.
;
;* Neither the name of LADSoft nor the names of its
;  contributors may be used to endorse or promote products
;  derived from this software without specific prior
;  written permission of LADSoft.
;
;THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
;WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
;PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
;ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
;LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
;INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
;TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
;ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;
	SECTION _TEXT BYTE CLASS=CODE USE32
	SECTION _DATA ALIGN=4 CLASS=DATA USE32
    [global ___code_seg_end]
___code_seg_end:
%include "..\..\copyrght.asm"
		db	" (i386/WIN32)"
	SECTION _BSS  ALIGN=4 CLASS=BSS USE32
		dd	0004E4957h
BssStart:
	SECTION _BSSEND_  ALIGN=4 CLASS=BSS USE32
BssEnd:
		dd	00044414ch
	SECTION _CONST  ALIGN=4 CLASS=CONST USE32
	SECTION _STRING  ALIGN=4 CLASS=STRING USE32
	SECTION cstartup ALIGN=4 CLASS=INITDATA USE32
InitStart:
	SECTION _STARTUPEND_ ALIGN=4 CLASS=INITDATA USE32
InitEnd	dd	0
		dd	0
	SECTION crundown ALIGN=4 CLASS=EXITDATA USE32
ExitStart:
	SECTION _RUNDOWNEND_ ALIGN=4 CLASS=EXITDATA USE32
ExitEnd:
		dd	0
	SECTION cppinit  ALIGN=4 CLASS=CPPINIT USE32
CppStart:
		dd	cpproutine,130
	SECTION _CPPEND_  ALIGN=4 CLASS=CPPINIT USE32
CppEnd:
		dd	0
	SECTION cppexit  ALIGN=4 CLASS=CPPEXIT USE32
CpprStart:
	SECTION _CPPREND_  ALIGN=4 CLASS=CPPEXIT USE32
CpprEnd:
		dd	0

DGROUP group _DATA,cstartup,_STARTUPEND_,crundown,_RUNDOWNEND_,cppinit,_CPPEND_,_BSS,_BSSEND_

	SECTION _DATA
	align 4
[global __oscmd]
[global __osenv]
[global __hinstance]
[global __isDLL]
[global __win32]

__oscmd		dd	0
__osenv		dd	0
__hinstance	dd	0
%ifdef		CONSOLE
__win32		dd	0
%else
__win32		dd	1
%endif
xcptsv1		dd	0
xcptsv2		dd	0
xcptp1          dd      0
xcptp2          dd      0
espsave         dd      0
%ifdef 		DLL
dllexists	dd	0
__isDLL         dd      1
nError		db	"Error",0
nNonSharedDataSeg db	"NonShared data segment required",0
%else
__isDLL         dd      0
%endif
unalignesp		dd		0
SECTION	_TEXT
;
; C startup procedures
;
[global ___code_seg_start]

___code_seg_start:
..start:
%ifndef DLL
                push    0               ; so the debugger can find the TOS
%endif
		push	ebp
		mov	ebp,esp
		sub	esp,8	; win32 exception struct
		push	esi
		push	edi
		push	ebx
        mov     [espsave],esp

%ifdef		DLL
		cmp	dword [ebp+12],1
		jnz	ndll1
		cmp	dword [dllexists],0
		jz	cdll1
		push	0
		push	nError
		push	nNonSharedDataSeg
		push	0
		extern	MessageBoxA
		call	MessageBoxA
		sub	eax,eax
		jmp	dllfin
cdll1:
		inc 	dword [dllexists]		
				

ndll1:
		cmp	dword [ebp + 12], 1	; process attach?
		jnz	near ndll2				; no don't init
%endif

		extern GetEnvironmentStrings 
		call  GetEnvironmentStrings
		mov   [__osenv],eax

%ifndef DLL
		extern GetCommandLineA 
		call  GetCommandLineA
		mov   [__oscmd],eax
%endif

		extern GetModuleHandleA 
		push	0
		call  GetModuleHandleA
		mov   [__hinstance], eax

;
; not used right now, may use it later...
;
		mov	edx,[fs:4]
		mov	eax,[edx-4]
		mov	[xcptsv1],eax
		mov	eax,[edx-8]
		mov	[xcptsv2],eax
                sub     edx,4
                mov     [xcptp1],edx
                mov     dword [edx],0
                sub     edx,4
                mov     [xcptp2],edx
                mov     dword [edx],0
;                mov     [espsave],esp
                cmp     esp,edx
                jb      noadjesp
                mov     esp,edx
noadjesp:
%ifndef DLL
		extern  __llfpinit
		call   __llfpinit
%endif
		
		extern	__xceptinit 
		lea	eax,[ebp-8] ; We put this on the stack in case the data seg gets wiped...
		push	eax
		call	__xceptinit
        
        extern  ___threadinit
        call    ___threadinit
;
; Execute startup routines
;
		mov	ecx,InitStart
		mov	edx,InitEnd
		call	sexproc
		cld
;
; Execute C++ class initializers
;
		mov	ecx,CppStart
		mov	edx,CppEnd
		call	sexproc
		cld
%ifdef DLL
ndll2:
%endif
;
; Call main
;
%ifdef		CONSOLE
                extern   __argv
				extern   __argc,
				extern __environ
		mov		[unalignesp],esp
		and		esp,-16
		sub		esp,12
		push	dword [__environ]
                push    dword [__argv]
		push	dword [__argc]
%ifdef DEBUG
		extern monitor_init
		call monitor_init
%endif
		extern	_main 
		call	_main
		add	esp,12
		mov		esp,[unalignesp]
%else
%ifdef 		DLL
		mov		[unalignesp],esp
		and		esp,-16
		sub		esp,12
                push    dword [ebp+16]
		push	dword [ebp+12]
                push    dword [ebp+8]
		extern	DllEntryPoint 
		call	DllEntryPoint
		mov		esp,[unalignesp]
%else
; Bypass command name
		mov	esi,[__oscmd]
wlp1:
		lodsb
                or      al,al
                jz      wend
 		cmp	al,' '
		jz	wlp1
		cmp	al,9
		jz 	wlp1
		mov	dl,' '
		cmp	al,'"'
		jnz	wlp2
		inc	esi
		mov	dl,al
wlp2:
		lodsb
                or      al,al
                jz      wend
		cmp	al,dl
		jz	wx1
		or	al,al
		jnz	wlp2

wx1:
		cmp	al,'"'
		jnz	wx2
		inc	esi
wx2:	
		lodsb
                or      al,al
                jz      wend
		cmp	al,' '
		jz	wx2
		cmp	al,9
		jz	wx2
wend:
		dec	esi

		mov		[unalignesp],esp
		and		esp,-16
		sub		esp,8
		
		push    10
		push	esi
		push	0
		push	dword [__hinstance]

		extern	WinMain 
		call	WinMain
		mov		esp,[unalignesp]
%endif
%endif
; exit/abort comes here
;
[global __rexit]
[global __rexita]
__rexit:
%ifdef	DLL
		cmp	dword [ebp+12],0 ; process detach?
		jnz	dlls1
%endif
		push	eax		; saving C return code
;
; Execute C++ class rundown routines
;
		cld
		mov	ecx,CpprStart
		mov	edx,CpprEnd
		call	sexproc
;
; Execute rundown routines
;
		mov	ecx,ExitStart
		mov	edx,ExitEnd
		call	sexproc
                pop     eax
%ifdef DLL
dlls1:
%endif
__rexita:
                mov     esp,[espsave] 
%ifdef	DLL
		cmp	dword [ebp+12],0	; process detach?
		jnz	dllfin
%endif

                push    eax         
		mov	edx,[fs:4]
                mov     ecx,[xcptsv1]
                mov     [edx-4],ecx
                mov     ecx,[xcptsv2]
                mov     [edx-8],ecx
		extern	__xceptrundown 
		call	__xceptrundown

%ifndef DLL
		extern	___crtexit
		call	___crtexit			; never returns if linked to CRTDLL
		extern   ExitProcess 
		call	ExitProcess ; return code already on stack
%endif
; probably don't get here, but be safe...
                pop     eax
%ifdef DLL
dllfin:
%endif
		pop	ebx
		pop	edi
		pop	esi
		mov	esp,ebp
		pop	ebp
%ifdef DLL
		ret	12
		push 	0
		extern   ExitProcess 
		call	ExitProcess ;/* make the debugger happy */
%else
                pop     eax     ; pop the 0
		ret
%endif
;
; Handle startup/rundown routines
;
sexproc:
		cmp	ecx,edx		
		jz	short sexpdone	
		mov	edi,ecx
		sub	ebx,ebx
		sub	eax,eax
spl2:
		cmp	edi,edx
		jz	short spo
		test	dword [edi+4],-1
		jz	short spl3
		cmp	eax,[edi+4]
		jnc	short spl3
		mov	ebx,edi
		mov	eax,[edi+4]
spl3:
		add	edi,8
		jmp	spl2
spo:
		or	ebx,ebx
		jz	short sexpdone
		mov	dword [ebx+4],0
		push	edx
		push	ecx
		call	[ebx]
		pop	ecx
		pop	edx
		jmp	sexproc
sexpdone:
		ret

; This is called as the first thing from the C++ main routine
cpproutine:
		ret

