/*
	Software License Agreement (BSD License)
	
	Copyright (c) 1997-2008, David Lindauer, (LADSoft).
	All rights reserved.
	
	Redistribution and use of this software in source and binary forms, with or without modification, are
	permitted provided that the following conditions are met:
	
	* Redistributions of source code must retain the above
	  copyright notice, this list of conditions and the
	  following disclaimer.
	
	* Redistributions in binary form must reproduce the above
	  copyright notice, this list of conditions and the
	  following disclaimer in the documentation and/or other
	  materials provided with the distribution.
	
	* Neither the name of LADSoft nor the names of its
	  contributors may be used to endorse or promote products
	  derived from this software without specific prior
	  written permission of LADSoft.
	
	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
	WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
	PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
	ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
	LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
	TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
	ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <wchar.h>
#include <locale.h>
#include "libp.h"

#ifdef __BIG_ENDIAN
#define __swap(x,y)
#else
static void __swap(wchar_t *s, int len)
{
    int i;
    for (i=0; i < len; i++,s++) {
        wchar_t x = *s;
        *s = ((unsigned)x >> 8) + (x << 8);
    }
}
#endif
int _RTL_FUNC vfwprintf(FILE *restrict stream, const wchar_t *restrict format, 
        va_list arglist)
{
	int written=0;
	wchar_t buffer[8192],*p;
	int i = 0;
	while (*format) {
        p = buffer;
		while (*format != '%' && *format != 0 && p < buffer + sizeof(buffer))
			*p++ = *format++;
        __swap(buffer,p-buffer);
      	if (fwrite(buffer,2,p-buffer,stream) != p-buffer)
		    return WEOF;
        written += p-buffer;
		if (*format == '%') {
            if  (*(format+1)) {
                p = buffer;
                format = __wonetostr(buffer,&p,format+1,((char **)arglist+i),&i, &written);
                __swap(buffer,p-buffer);
                if (fwrite(buffer,2,p-buffer,stream) != p-buffer)
		            return EOF;
                written += p-buffer;
            } else
                format++;
        }
	}
	return written;
}
int _RTL_FUNC fwprintf(FILE *restrict stream, const wchar_t *restrict format, ...)
{
	return vfwprintf(stream,format,((char *)&format+sizeof(wchar_t *)));
}