;Software License Agreement (BSD License)
;
;Copyright (c) 1997-2008, David Lindauer, (LADSoft).
;All rights reserved.
;
;Redistribution and use of this software in source and binary forms, with or without modification, are
;permitted provided that the following conditions are met:
;
;* Redistributions of source code must retain the above
;  copyright notice, this list of conditions and the
;  following disclaimer.
;
;* Redistributions in binary form must reproduce the above
;  copyright notice, this list of conditions and the
;  following disclaimer in the documentation and/or other
;  materials provided with the distribution.
;
;* Neither the name of LADSoft nor the names of its
;  contributors may be used to endorse or promote products
;  derived from this software without specific prior
;  written permission of LADSoft.
;
;THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
;WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
;PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
;ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
;LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
;INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
;TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
;ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	.386

;
; Section inits
;
_TEXT	        SEGMENT DWORD PUBLIC USE32 'CODE'
	extrn	__argv_arr,__argc,__environ,__cmdline
	extrn	_main:PROC
	public  __rexit
		ENDS
cstartup        SEGMENT DWORD PUBLIC USE32 'INITDATA'
InitStart       label dword
                ENDS
_STARTUPEND_       SEGMENT DWORD PUBLIC USE32 'INITDATA'
InitEnd         label dword
                ENDS
crundown        SEGMENT DWORD PUBLIC USE32 'EXITDATA'
ExitStart       label dword
                ENDS
_RUNDOWNEND_       SEGMENT DWORD PUBLIC USE32 'EXITDATA'
ExitEnd         label dword
                ENDS
_CPP_           SEGMENT DWORD PUBLIC USE32 'CPPDATA'
CppStart        label dword
		dd	cpproutine
                ENDS
_CPPEND_        SEGMENT DWORD PUBLIC USE32 'CPPDATA'
CppEnd          label dword
		ENDS
_DATA   	SEGMENT DWORD PUBLIC USE32 'DATA'
		db	"Copyright (c) 1996 LADsoft C runtime library (i386)"
                ENDS
_BSS	        SEGMENT DWORD PUBLIC USE32 'BSS'
BssStart	label dword
                ENDS
_BSSEND	        SEGMENT DWORD PUBLIC USE32 'BSS'
BssEnd		label dword
                ENDS

DGROUP group cstartup,_STARTUPEND_,crundown,_RUNDOWNEND_,_CPP_,_CPPEND_,_DATA,_BSS,_BSSEND
_TEXT		SEGMENT
		assume cs:_TEXT,ds:DGROUP
;
; Main program
;
start:
;
; Assumes ESP is set
;
; Set up dummy command line
;
; Clear BSS
;
		mov	edi,offset BssStart
		mov	ecx,offset BssEnd
		sub	ecx,edi
		sub	eax,eax
		cld
		rep	stosb
;
; Execute startup routines
;
		mov	ecx,offset InitStart
		mov	edx,offset InitEnd
		call	sexproc
;
; Call main
;
		push	__environ
		push	__argv_arr
		push	__argc
		call	_main
		add	esp,12
;
; exit/abort comes here
;
__rexit:
;
; Execute rundown routines
;
		push	eax
		mov	ecx,offset ExitStart
		mov	edx,offset ExitEnd
		call	sexproc
		pop	eax
		ret			; exit to os
;
; Handle startup/rundown routines
;
sexproc:
		cmp	ecx,edx		
		jz	short sexpdone	
		mov	edi,ecx
		sub	ebx,ebx
		sub	eax,eax
spl2:
		cmp	edi,edx
		jz	short spo
		test	dword ptr [edi+4],-1
		jz	short spl3
		cmp	eax,[edi+4]
		jnc	short spl3
		mov	ebx,edi
		mov	eax,[edi+4]
spl3:
		add	edi,8
		jmp	spl2
spo:
		or	ebx,ebx
		jz	short sexpdone
		mov	dword ptr [ebx+4],0
		mov	ebx,[ebx]
		push	edx
		push	ecx
		call	ebx
		pop	ecx
		pop	edx
		jmp	sexproc
sexpdone:
		ret

; This is called as the first thing from the C++ main routine
cpproutine:
		ret
_TEXT		ends
		end 