;Software License Agreement (BSD License)
;
;Copyright (c) 1997-2008, David Lindauer, (LADSoft).
;All rights reserved.
;
;Redistribution and use of this software in source and binary forms, with or without modification, are
;permitted provided that the following conditions are met:
;
;* Redistributions of source code must retain the above
;  copyright notice, this list of conditions and the
;  following disclaimer.
;
;* Redistributions in binary form must reproduce the above
;  copyright notice, this list of conditions and the
;  following disclaimer in the documentation and/or other
;  materials provided with the distribution.
;
;* Neither the name of LADSoft nor the names of its
;  contributors may be used to endorse or promote products
;  derived from this software without specific prior
;  written permission of LADSoft.
;
;THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
;WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
;PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
;ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
;LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
;INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
;TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
;ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
%include "matherr.inc"

%ifdef __BUILDING_LSCRTL_DLL
[export _frexp]
[export _frexpf]
[export _frexpl]
%endif
[global _frexp]
[global _frexpf]
[global _frexpl]
SECTION _DATA CLASS=DATA USE32
nm	db	"frexp",0

SECTION _TEXT CLASS=CODE USE32

four	dw	4

_frexpf:
	lea	ecx,[esp+4]
	fld	dword[ecx]
	mov	ecx,[esp+8]
    sub dl,dl
    jmp short frexp
_frexpl:
	lea	ecx,[esp+4]
	fld	tword[ecx]
	mov	ecx,[esp+16]
    mov dl,2
    jmp short frexp
_frexp:
	lea	ecx,[esp+4]
	fld	qword[ecx]
	mov	ecx,[esp+12]
    mov dl,1
frexp:
    lea eax,[nm]
    call clearmath
    fldz
    fcomp   st1
    fstsw   ax
    sahf
    jz  zero
	fxtract
	fxch	st1
	fld1
	fadd	st1,st0
    faddp st1
    jmp join
zero:
    popone
    fldz
    fldz
join:
    fistp   dword[ecx]
	fild	word[four]
	fdivp	st1
    jmp wrapmath
