/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.flat;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.internal.flat.IChildModuleReference;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFile;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class ChildModuleReference
implements IChildModuleReference {
    private IProject project;
    private File file;
    private IVirtualComponent component;
    private IVirtualReference reference;
    private IPath uri;

    public ChildModuleReference(IProject project, IFlatFile f) {
        this.project = project;
        File file = this.file = f == null ? null : (File)f.getAdapter(File.class);
        if (f != null && this.file != null) {
            this.uri = f.getModuleRelativePath().append(f.getName());
        }
    }

    public ChildModuleReference(IVirtualReference reference, IPath root) {
        File f;
        this.reference = reference;
        this.component = reference.getReferencedComponent();
        this.project = this.component.getProject();
        if (this.component.isBinary() && (f = (File)this.component.getAdapter(File.class)).exists() && f.isFile()) {
            this.file = f;
        }
        this.uri = root.append(reference.getRuntimePath()).append(reference.getArchiveName());
    }

    public File getFile() {
        return this.file;
    }

    public IVirtualReference getReference() {
        return this.reference;
    }

    public IVirtualComponent getComponent() {
        if (this.component != null) {
            return this.component;
        }
        if (this.file != null) {
            return new VirtualArchiveComponent(this.project, "lib/" + this.file.getAbsolutePath(), (IPath)new Path("/"));
        }
        return null;
    }

    public boolean isBinary() {
        return this.component == null || this.component.isBinary();
    }

    public IPath getRelativeURI() {
        return this.uri;
    }
}

