/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.persistence;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JarFile;
import org.eclipse.jpt.jpa.core.context.persistence.JarFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePackageFragmentRoot;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJarFileRef;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJarFileRef
extends AbstractPersistenceXmlContextNode
implements JarFileRef {
    protected final XmlJarFileRef xmlJarFileRef;
    protected String fileName;
    protected JarFile jarFile;

    public AbstractJarFileRef(PersistenceUnit parent, XmlJarFileRef xmlJarFileRef) {
        super(parent);
        this.xmlJarFileRef = xmlJarFileRef;
        this.fileName = xmlJarFileRef.getFileName();
        this.jarFile = this.buildJarFile();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setFileName_(this.xmlJarFileRef.getFileName());
        this.syncJarFile();
    }

    @Override
    public void update() {
        super.update();
        this.updateJarFile();
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.jpa.core.persistence.jarFileRef";
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlJarFileRef == null ? null : this.xmlJarFileRef.getSelectionTextRange();
    }

    @Override
    public void dispose() {
        if (this.jarFile != null) {
            this.jarFile.dispose();
        }
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.setFileName_(fileName);
        this.xmlJarFileRef.setFileName(fileName);
    }

    protected void setFileName_(String fileName) {
        String old = this.fileName;
        this.fileName = fileName;
        if (this.firePropertyChanged("fileName", old, fileName) && this.jarFile != null) {
            this.jarFile.dispose();
            this.setJarFile(null);
        }
    }

    @Override
    public JarFile getJarFile() {
        return this.jarFile;
    }

    protected void setJarFile(JarFile jarFile) {
        JarFile old = this.jarFile;
        this.jarFile = jarFile;
        this.firePropertyChanged("jarFile", old, jarFile);
    }

    protected JarFile buildJarFile() {
        JavaResourcePackageFragmentRoot jrpfr = this.resolveJavaResourcePackageFragmentRoot();
        return jrpfr == null ? null : this.buildJarFile(jrpfr);
    }

    protected void syncJarFile() {
        if (this.jarFile != null) {
            this.jarFile.synchronizeWithResourceModel();
        }
    }

    protected void updateJarFile() {
        JavaResourcePackageFragmentRoot jrpfr = this.resolveJavaResourcePackageFragmentRoot();
        if (jrpfr == null) {
            if (this.jarFile != null) {
                this.jarFile.dispose();
                this.setJarFile(null);
            }
        } else if (this.jarFile == null) {
            this.setJarFile(this.buildJarFile(jrpfr));
        } else if (this.jarFile.getJarResourcePackageFragmentRoot() == jrpfr) {
            this.jarFile.update();
        } else {
            this.jarFile.dispose();
            this.setJarFile(this.buildJarFile(jrpfr));
        }
    }

    protected JavaResourcePackageFragmentRoot resolveJavaResourcePackageFragmentRoot() {
        return StringTools.stringIsEmpty((String)this.fileName) ? null : this.resolveJavaResourcePackageFragmentRoot_();
    }

    protected JavaResourcePackageFragmentRoot resolveJavaResourcePackageFragmentRoot_() {
        JavaResourcePackageFragmentRoot jrpfr = this.resolveJrpfrOnDeploymentPath();
        return jrpfr != null ? jrpfr : this.resolveJrpfrBestMatch();
    }

    protected JavaResourcePackageFragmentRoot resolveJrpfrOnDeploymentPath() {
        IPath[] iPathArray = this.buildRuntimeJarFilePath((IPath)new Path(this.fileName));
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath runtimePath = iPathArray[n2];
            IVirtualFile virtualJar = ComponentCore.createFile((IProject)this.getProject(), (IPath)runtimePath);
            IFile realJar = virtualJar.getUnderlyingFile();
            if (realJar.exists() && realJar.getProject().equals((Object)this.getProject())) {
                return this.getJpaProject().getJavaResourcePackageFragmentRoot(realJar.getProjectRelativePath().toString());
            }
            ++n2;
        }
        return null;
    }

    protected IPath[] buildRuntimeJarFilePath(IPath jarFilePath) {
        IPath root = this.getJarRuntimeRootPath();
        return this.projectHasWebFacet() ? this.buildRuntimeJarFilePathWeb(root, jarFilePath) : this.buildRuntimeJarFilePathNonWeb(root, jarFilePath);
    }

    protected IPath getJarRuntimeRootPath() {
        return JptJpaCorePlugin.getJarRuntimeRootPath(this.getProject());
    }

    protected boolean projectHasWebFacet() {
        return JptJpaCorePlugin.projectHasWebFacet(this.getProject());
    }

    protected IPath[] buildRuntimeJarFilePathWeb(IPath root, IPath jarFilePath) {
        return new IPath[]{root.append(jarFilePath.removeFirstSegments(1)), root.append(jarFilePath)};
    }

    protected IPath[] buildRuntimeJarFilePathNonWeb(IPath root, IPath jarFilePath) {
        return new IPath[]{root.append(jarFilePath)};
    }

    protected IProject getProject() {
        return this.getJpaProject().getProject();
    }

    protected JavaResourcePackageFragmentRoot resolveJrpfrBestMatch() {
        String jarFileName = new Path(this.fileName).lastSegment();
        for (JpaFile jpaFile : this.getJpaProject().getJarJpaFiles()) {
            if (!jpaFile.getFile().getName().equals(jarFileName)) continue;
            return (JavaResourcePackageFragmentRoot)jpaFile.getResourceModel();
        }
        return null;
    }

    protected JarFile buildJarFile(JavaResourcePackageFragmentRoot jrpfr) {
        return this.getContextNodeFactory().buildJarFile(this, jrpfr);
    }

    @Override
    public XmlJarFileRef getXmlJarFileRef() {
        return this.xmlJarFileRef;
    }

    @Override
    public PersistentType getPersistentType(String typeName) {
        return this.jarFile == null ? null : this.jarFile.getPersistentType(typeName);
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.xmlJarFileRef != null && this.xmlJarFileRef.containsOffset(textOffset);
    }

    @Override
    public Iterable<? extends PersistentType> getPersistentTypes() {
        return this.jarFile != null ? this.jarFile.getPersistentTypes() : EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlJarFileRefTextRange();
        return textRange != null ? textRange : this.getPersistenceUnit().getValidationTextRange();
    }

    protected TextRange getXmlJarFileRefTextRange() {
        return this.xmlJarFileRef == null ? null : this.xmlJarFileRef.getValidationTextRange();
    }

    @Override
    public Iterable<ReplaceEdit> createReplaceFolderEdits(IFolder originalFolder, String newName) {
        return this.isIn(originalFolder) ? new SingleElementIterable((Object)this.createReplaceFolderEdit(originalFolder, newName)) : EmptyIterable.instance();
    }

    protected ReplaceEdit createReplaceFolderEdit(IFolder originalFolder, String newName) {
        return this.xmlJarFileRef.createReplaceFolderEdit(originalFolder, newName);
    }

    protected boolean isIn(IFolder folder) {
        return this.jarFile != null && this.jarFile.isIn(folder);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (StringTools.stringIsEmpty((String)this.xmlJarFileRef.getFileName())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_UNSPECIFIED_JAR_FILE", this, this.getValidationTextRange()));
            return;
        }
        messages.add(DefaultJpaValidationMessages.buildMessage(2, "PERSISTENCE_UNIT_JAR_FILE_DEPLOYMENT_PATH_WARNING", this, this.getValidationTextRange()));
        if (this.jarFile == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_NONEXISTENT_JAR_FILE", new String[]{this.xmlJarFileRef.getFileName()}, this, this.getValidationTextRange()));
            return;
        }
        this.jarFile.validate(messages, reporter);
    }

    @Override
    public PersistenceUnit getParent() {
        return (PersistenceUnit)super.getParent();
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.fileName);
    }
}

