/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyReferenceTable;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaReferenceTable;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaTable;
import org.eclipse.jpt.jpa.core.internal.resource.java.NullJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ReferenceTableAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericJavaReferenceTable<A extends ReferenceTableAnnotation>
extends AbstractJavaTable<A>
implements JavaReferenceTable {
    protected final Vector<JavaJoinColumn> specifiedJoinColumns = new Vector();
    protected final SpecifiedJoinColumnContainerAdapter specifiedJoinColumnContainerAdapter = new SpecifiedJoinColumnContainerAdapter();
    protected final JavaJoinColumn.Owner joinColumnOwner = this.buildJoinColumnOwner();
    protected JavaJoinColumn defaultJoinColumn;

    protected GenericJavaReferenceTable(JavaJpaContextNode parent, Table.Owner owner) {
        super(parent, owner);
        this.initializeSpecifiedJoinColumns();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncSpecifiedJoinColumns();
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedJoinColumns());
        this.updateDefaultJoinColumn();
    }

    @Override
    public ListIterator<JavaJoinColumn> joinColumns() {
        return this.getJoinColumns().iterator();
    }

    protected ListIterable<JavaJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    @Override
    public void convertDefaultToSpecifiedJoinColumn() {
        MappingTools.convertReferenceTableDefaultToSpecifiedJoinColumn(this);
    }

    @Override
    public ListIterator<JavaJoinColumn> specifiedJoinColumns() {
        return this.getSpecifiedJoinColumns().iterator();
    }

    protected ListIterable<JavaJoinColumn> getSpecifiedJoinColumns() {
        return new LiveCloneListIterable(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.specifiedJoinColumns.size() != 0;
    }

    @Override
    public JavaJoinColumn getSpecifiedJoinColumn(int index) {
        return this.specifiedJoinColumns.get(index);
    }

    @Override
    public JavaJoinColumn addSpecifiedJoinColumn() {
        return this.addSpecifiedJoinColumn(this.specifiedJoinColumns.size());
    }

    @Override
    public JavaJoinColumn addSpecifiedJoinColumn(int index) {
        JoinColumnAnnotation annotation = ((ReferenceTableAnnotation)this.getTableAnnotation()).addJoinColumn(index);
        return this.addSpecifiedJoinColumn_(index, annotation);
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        ((ReferenceTableAnnotation)this.getTableAnnotation()).removeJoinColumn(index);
        this.removeTableAnnotationIfUnset();
        this.removeSpecifiedJoinColumn_(index);
    }

    protected void removeSpecifiedJoinColumn_(int index) {
        this.removeItemFromList(index, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        ((ReferenceTableAnnotation)this.getTableAnnotation()).moveJoinColumn(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    protected void initializeSpecifiedJoinColumns() {
        for (JoinColumnAnnotation joinColumnAnnotation : this.getJoinColumnAnnotations()) {
            this.specifiedJoinColumns.add(this.buildJoinColumn(joinColumnAnnotation));
        }
    }

    protected void syncSpecifiedJoinColumns() {
        ContextContainerTools.synchronizeWithResourceModel(this.specifiedJoinColumnContainerAdapter);
    }

    protected Iterable<JoinColumnAnnotation> getJoinColumnAnnotations() {
        return CollectionTools.iterable(((ReferenceTableAnnotation)this.getTableAnnotation()).joinColumns());
    }

    protected void moveSpecifiedJoinColumn_(int index, JavaJoinColumn joinColumn) {
        this.moveItemInList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    protected JavaJoinColumn addSpecifiedJoinColumn_(int index, JoinColumnAnnotation joinColumnAnnotation) {
        JavaJoinColumn joinColumn = this.buildJoinColumn(joinColumnAnnotation);
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
        return joinColumn;
    }

    protected void removeSpecifiedJoinColumn_(JavaJoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn_(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    protected abstract JavaJoinColumn.Owner buildJoinColumnOwner();

    @Override
    public JavaJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(JavaJoinColumn joinColumn) {
        JavaJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<JavaJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn() {
        if (this.buildsDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(new NullJoinColumnAnnotation((JavaResourceNode)this.getTableAnnotation())));
            } else {
                this.defaultJoinColumn.update();
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean buildsDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns();
    }

    protected void initializeFrom(ReadOnlyReferenceTable oldTable) {
        super.initializeFrom(oldTable);
        for (ReadOnlyJoinColumn joinColumn : CollectionTools.iterable(oldTable.specifiedJoinColumns())) {
            this.addSpecifiedJoinColumn().initializeFrom(joinColumn);
        }
    }

    protected void initializeFromVirtual(ReadOnlyReferenceTable virtualTable) {
        super.initializeFromVirtual(virtualTable);
        for (ReadOnlyJoinColumn joinColumn : CollectionTools.iterable(virtualTable.joinColumns())) {
            this.addSpecifiedJoinColumn().initializeFromVirtual(joinColumn);
        }
    }

    protected JavaJoinColumn buildJoinColumn(JoinColumnAnnotation joinColumnAnnotation) {
        return this.buildJoinColumn(this.joinColumnOwner, joinColumnAnnotation);
    }

    protected JavaJoinColumn buildJoinColumn(JavaJoinColumn.Owner jcOwner, JoinColumnAnnotation joinColumnAnnotation) {
        return this.getJpaFactory().buildJavaJoinColumn(this, jcOwner, joinColumnAnnotation);
    }

    @Override
    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaJoinColumn column : CollectionTools.iterable(this.joinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        boolean continueValidating = this.buildTableValidator(astRoot).validate(messages, reporter);
        if (continueValidating) {
            this.validateJoinColumns(messages, reporter, astRoot);
        }
    }

    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.validateJoinColumns(this.joinColumns(), messages, reporter, astRoot);
    }

    protected void validateJoinColumns(Iterator<JavaJoinColumn> joinColumns, List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        while (joinColumns.hasNext()) {
            joinColumns.next().validate(messages, reporter, astRoot);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedJoinColumnContainerAdapter
    implements ContextContainerTools.Adapter<JavaJoinColumn, JoinColumnAnnotation> {
        protected SpecifiedJoinColumnContainerAdapter() {
        }

        @Override
        public Iterable<JavaJoinColumn> getContextElements() {
            return GenericJavaReferenceTable.this.getSpecifiedJoinColumns();
        }

        @Override
        public Iterable<JoinColumnAnnotation> getResourceElements() {
            return GenericJavaReferenceTable.this.getJoinColumnAnnotations();
        }

        @Override
        public JoinColumnAnnotation getResourceElement(JavaJoinColumn contextElement) {
            return contextElement.getColumnAnnotation();
        }

        @Override
        public void moveContextElement(int index, JavaJoinColumn element) {
            GenericJavaReferenceTable.this.moveSpecifiedJoinColumn_(index, element);
        }

        @Override
        public void addContextElement(int index, JoinColumnAnnotation resourceElement) {
            GenericJavaReferenceTable.this.addSpecifiedJoinColumn_(index, resourceElement);
        }

        @Override
        public void removeContextElement(JavaJoinColumn element) {
            GenericJavaReferenceTable.this.removeSpecifiedJoinColumn_(element);
        }
    }
}

