/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumnRelationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumnContainer;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmJoinColumnRelationshipStrategy
extends AbstractOrmXmlContextNode
implements OrmJoinColumnRelationshipStrategy {
    protected final Vector<OrmJoinColumn> specifiedJoinColumns = new Vector();
    protected final SpecifiedJoinColumnContainerAdapter specifiedJoinColumnContainerAdapter = this.buildSpecifiedJoinColumnContainerAdapter();
    protected final OrmJoinColumn.Owner joinColumnOwner = this.buildJoinColumnOwner();
    protected OrmJoinColumn defaultJoinColumn;

    protected AbstractOrmJoinColumnRelationshipStrategy(OrmJoinColumnRelationship parent) {
        super(parent);
        this.initializeSpecifiedJoinColumns();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncSpecifiedJoinColumns();
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedJoinColumns());
        this.updateDefaultJoinColumn();
    }

    protected XmlJoinColumnContainer getXmlJoinColumnContainer() {
        return this.getRelationship().getXmlContainer();
    }

    @Override
    public ListIterator<OrmJoinColumn> joinColumns() {
        return this.getJoinColumns().iterator();
    }

    protected ListIterable<OrmJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    @Override
    public ListIterator<OrmJoinColumn> specifiedJoinColumns() {
        return this.getSpecifiedJoinColumns().iterator();
    }

    protected ListIterable<OrmJoinColumn> getSpecifiedJoinColumns() {
        return new LiveCloneListIterable(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.specifiedJoinColumns.size() != 0;
    }

    @Override
    public OrmJoinColumn getSpecifiedJoinColumn(int index) {
        return this.specifiedJoinColumns.get(index);
    }

    @Override
    public OrmJoinColumn addSpecifiedJoinColumn() {
        return this.addSpecifiedJoinColumn(this.specifiedJoinColumns.size());
    }

    @Override
    public OrmJoinColumn addSpecifiedJoinColumn(int index) {
        XmlJoinColumn xmlJoinColumn = this.buildXmlJoinColumn();
        OrmJoinColumn joinColumn = this.addSpecifiedJoinColumn_(index, xmlJoinColumn);
        this.getXmlJoinColumnContainer().getJoinColumns().add(index, (Object)xmlJoinColumn);
        return joinColumn;
    }

    protected XmlJoinColumn buildXmlJoinColumn() {
        return OrmFactory.eINSTANCE.createXmlJoinColumn();
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        this.removeSpecifiedJoinColumn_(index);
        this.getXmlJoinColumnContainer().getJoinColumns().remove(index);
    }

    protected void removeSpecifiedJoinColumn_(int index) {
        this.removeItemFromList(index, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        this.moveItemInList(targetIndex, sourceIndex, this.specifiedJoinColumns, "specifiedJoinColumns");
        this.getXmlJoinColumnContainer().getJoinColumns().move(targetIndex, sourceIndex);
    }

    protected void initializeSpecifiedJoinColumns() {
        for (XmlJoinColumn xmlJoinColumn : this.getXmlJoinColumns()) {
            this.specifiedJoinColumns.add(this.buildJoinColumn(xmlJoinColumn));
        }
    }

    protected void syncSpecifiedJoinColumns() {
        ContextContainerTools.synchronizeWithResourceModel(this.specifiedJoinColumnContainerAdapter);
    }

    protected Iterable<XmlJoinColumn> getXmlJoinColumns() {
        return new LiveCloneIterable(this.getXmlJoinColumnContainer().getJoinColumns());
    }

    protected void moveSpecifiedJoinColumn_(int index, OrmJoinColumn joinColumn) {
        this.moveItemInList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    protected OrmJoinColumn addSpecifiedJoinColumn_(int index, XmlJoinColumn xmlJoinColumn) {
        OrmJoinColumn joinColumn = this.buildJoinColumn(xmlJoinColumn);
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
        return joinColumn;
    }

    protected void removeSpecifiedJoinColumn_(OrmJoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn_(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    protected SpecifiedJoinColumnContainerAdapter buildSpecifiedJoinColumnContainerAdapter() {
        return new SpecifiedJoinColumnContainerAdapter();
    }

    protected abstract OrmJoinColumn.Owner buildJoinColumnOwner();

    @Override
    public OrmJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(OrmJoinColumn joinColumn) {
        OrmJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<OrmJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn() {
        if (this.buildsDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(null));
            } else {
                this.defaultJoinColumn.update();
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean buildsDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns() && this.getRelationship().mayHaveDefaultJoinColumn();
    }

    @Override
    public OrmJoinColumnRelationship getParent() {
        return (OrmJoinColumnRelationship)super.getParent();
    }

    @Override
    public OrmJoinColumnRelationship getRelationship() {
        return this.getParent();
    }

    protected OrmJoinColumn buildJoinColumn(XmlJoinColumn xmlJoinColumn) {
        return this.getContextNodeFactory().buildOrmJoinColumn(this, this.joinColumnOwner, xmlJoinColumn);
    }

    @Override
    public void initializeFrom(ReadOnlyJoinColumnRelationshipStrategy oldStrategy) {
        for (ReadOnlyJoinColumn joinColumn : CollectionTools.iterable(oldStrategy.specifiedJoinColumns())) {
            this.addSpecifiedJoinColumn().initializeFrom(joinColumn);
        }
    }

    @Override
    public void initializeFromVirtual(ReadOnlyJoinColumnRelationshipStrategy virtualStrategy) {
        for (ReadOnlyJoinColumn joinColumn : CollectionTools.iterable(virtualStrategy.joinColumns())) {
            this.addSpecifiedJoinColumn().initializeFromVirtual(joinColumn);
        }
    }

    protected RelationshipMapping getRelationshipMapping() {
        return this.getRelationship().getMapping();
    }

    @Override
    public String getTableName() {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? null : typeMapping.getPrimaryTableName();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? null : typeMapping.resolveDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping != null && typeMapping.tableNameIsInvalid(tableName);
    }

    public Table getReferencedColumnDbTable() {
        TypeMapping relationshipTarget = this.getRelationshipTarget();
        return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
    }

    protected Iterator<String> candidateTableNames() {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping != null ? typeMapping.allAssociatedTableNames() : EmptyIterator.instance();
    }

    @Override
    public void addStrategy() {
        if (this.specifiedJoinColumnsSize() == 0) {
            this.addSpecifiedJoinColumn();
        }
    }

    @Override
    public void removeStrategy() {
        int i = this.specifiedJoinColumns.size();
        while (i-- > 0) {
            this.removeSpecifiedJoinColumn(i);
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        for (OrmJoinColumn joinColumn : this.getJoinColumns()) {
            joinColumn.validate(messages, reporter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedJoinColumnContainerAdapter
    implements ContextContainerTools.Adapter<OrmJoinColumn, XmlJoinColumn> {
        protected SpecifiedJoinColumnContainerAdapter() {
        }

        @Override
        public Iterable<OrmJoinColumn> getContextElements() {
            return AbstractOrmJoinColumnRelationshipStrategy.this.getSpecifiedJoinColumns();
        }

        @Override
        public Iterable<XmlJoinColumn> getResourceElements() {
            return AbstractOrmJoinColumnRelationshipStrategy.this.getXmlJoinColumns();
        }

        @Override
        public XmlJoinColumn getResourceElement(OrmJoinColumn contextElement) {
            return contextElement.getXmlColumn();
        }

        @Override
        public void moveContextElement(int index, OrmJoinColumn element) {
            AbstractOrmJoinColumnRelationshipStrategy.this.moveSpecifiedJoinColumn_(index, element);
        }

        @Override
        public void addContextElement(int index, XmlJoinColumn resourceElement) {
            AbstractOrmJoinColumnRelationshipStrategy.this.addSpecifiedJoinColumn_(index, resourceElement);
        }

        @Override
        public void removeContextElement(OrmJoinColumn element) {
            AbstractOrmJoinColumnRelationshipStrategy.this.removeSpecifiedJoinColumn_(element);
        }
    }
}

