/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.designtime.resolver.ISymbolContextResolver;
import org.eclipse.jst.jsf.designtime.resolver.StructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.validation.el.LocalizedMessage;
import org.eclipse.jst.jsf.validation.el.ValueExpressionTracker;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAddExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAndExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTChoiceExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTEqualityExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTFunctionInvocation;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTLiteral;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTMultiplyExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTOrExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTRelationalExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTUnaryExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValue;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValuePrefix;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValueSuffix;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParserVisitor;
import org.eclipse.jst.jsp.core.internal.java.jspel.SimpleNode;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

class ASTSemanticValidator
implements JSPELParserVisitor {
    private final IFile _targetFile;
    private final ASTExpression _expr;
    private final IStructuredDocumentContext _context;
    private final ISymbolContextResolver _symbolResolver;
    private final List _messages;

    ASTSemanticValidator(ASTExpression expr, IStructuredDocumentContext context) {
        IWorkspaceContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
        this._targetFile = resolver != null ? (IFile)resolver.getResource() : null;
        this._expr = expr;
        this._context = context;
        this._symbolResolver = StructuredDocumentSymbolResolverFactory.getInstance().getSymbolContextResolver(this._context);
        this._messages = new ArrayList();
    }

    public void validate() {
        this._expr.jjtAccept((JSPELParserVisitor)this, null);
    }

    public Object visit(ASTAddExpression node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTAndExpression node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTChoiceExpression node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTEqualityExpression node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTExpression node, Object data) {
        System.out.println("Expr: " + node.getFirstToken() + " " + node.getLastToken());
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTFunctionInvocation node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTLiteral node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTMultiplyExpression node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTOrExpression node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTRelationalExpression node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTUnaryExpression node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTValue node, Object data) {
        ValueExpressionTracker tracker = new ValueExpressionTracker(this._targetFile.getProject());
        Object retValue = node.childrenAccept((JSPELParserVisitor)this, (Object)tracker);
        if (!tracker.isErrorFlag() && tracker.getCurPropertySymbol() != null && tracker.getCurPropertySymbol().isIntermediate()) {
            int problemStartOffset = tracker.getCurPropertySymbolOffset();
            LocalizedMessage message = new LocalizedMessage(2, (IResource)this._targetFile, 1, new Object[]{tracker.getCurPropertySymbol().getName()});
            message.setOffset(problemStartOffset);
            message.setLength(tracker.getCurPropertySymbolLength());
            message.setTargetObject(this._targetFile);
            message.setAttribute("name", tracker.getCurPropertySymbol().getName());
            this._messages.add(message);
        }
        return retValue;
    }

    public Object visit(ASTValuePrefix node, Object data) {
        ValueExpressionTracker tracker = (ValueExpressionTracker)data;
        if (!tracker.isErrorFlag() && node.jjtGetNumChildren() == 0) {
            Token token = node.getFirstToken();
            String image = token.image;
            ISymbol symbol = this._symbolResolver.getSymbol(image);
            if (symbol == null) {
                int problemStartOffset = this._context.getDocumentPosition() + token.beginColumn - 1;
                LocalizedMessage message = new LocalizedMessage(2, (IResource)this._targetFile, 0, new Object[]{image});
                message.setOffset(problemStartOffset);
                message.setLength(token.endColumn - token.beginColumn + 1);
                message.setTargetObject(this._targetFile);
                message.setAttribute("name", image);
                this._messages.add(message);
            } else {
                tracker.setRootSymbol(symbol);
            }
        }
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTValueSuffix node, Object data) {
        ValueExpressionTracker tracker = (ValueExpressionTracker)data;
        if (!tracker.isErrorFlag()) {
            Token firstToken = node.getFirstToken();
            if (node.jjtGetNumChildren() == 0 && firstToken.kind == 13) {
                Token dotId = node.getLastToken();
                if (tracker.isRootValid()) {
                    int startOffset = this._context.getDocumentPosition() + dotId.beginColumn - 1;
                    int length = dotId.endColumn - dotId.beginColumn + 1;
                    if (!tracker.isValidMemberOfCurrentSymbol(dotId.image)) {
                        LocalizedMessage message = new LocalizedMessage(2, (IResource)this._targetFile, 1, new Object[]{dotId.image, tracker.getRootSymbol().getName()});
                        message.setOffset(startOffset);
                        message.setLength(length);
                        message.setTargetObject(this._targetFile);
                        this._messages.add(message);
                        tracker.setErrorFlag(true);
                    } else {
                        tracker.setCurPropertySymbol(tracker.getNextPropertySymbol(dotId.image), startOffset, length);
                    }
                }
            }
        }
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(SimpleNode node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public void reportFindings(IValidator validator, IReporter reporter) {
        Iterator it = this._messages.iterator();
        while (it.hasNext()) {
            reporter.addMessage(validator, (IMessage)it.next());
        }
    }

    public List getMessages() {
        return this._messages;
    }
}

