/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.symbols;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.context.symbol.IBeanInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.AbstractSymbolSourceProviderFactory;
import org.eclipse.jst.jsf.context.symbol.source.ISymbolConstants;
import org.eclipse.jst.jsf.context.symbol.source.ISymbolSourceProvider;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class DefaultBeanSymbolSourceProvider
extends AbstractSymbolSourceProviderFactory
implements ISymbolSourceProvider {
    protected ISymbolSourceProvider create(IProject project) {
        return this;
    }

    public ISymbol[] getSymbols(IAdaptable context, int symbolScopeMask) {
        if (context != null) {
            IProject myProject = this.getProject();
            List managedBeans = this.getManagedBeanSymbols(myProject, symbolScopeMask);
            return managedBeans.toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
        }
        return ISymbol.EMPTY_SYMBOL_ARRAY;
    }

    public ISymbol[] getSymbols(String prefix, IAdaptable context, int symbolScopeMask) {
        ISymbol[] allSymbols = this.getSymbols(context, symbolScopeMask);
        ArrayList<ISymbol> filteredSymbols = new ArrayList<ISymbol>(allSymbols.length);
        int i = 0;
        while (i < allSymbols.length) {
            if (allSymbols[i].getName().startsWith(prefix)) {
                filteredSymbols.add(allSymbols[i]);
            }
            ++i;
        }
        return filteredSymbols.toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
    }

    public boolean isProvider(IAdaptable context) {
        return context != null;
    }

    private List getManagedBeanSymbols(IProject iProject, int symbolScopeMask) {
        ArrayList<IBeanInstanceSymbol> arrayList;
        block7: {
            ArrayList<IBeanInstanceSymbol> symbols = new ArrayList<IBeanInstanceSymbol>();
            FacesConfigArtifactEdit artifact = null;
            try {
                artifact = this.getArtifact(iProject);
                FacesConfigType facesConfig = artifact.getFacesConfig();
                if (facesConfig != null) {
                    Iterator aIt = facesConfig.getManagedBean().iterator();
                    while (aIt.hasNext()) {
                        ManagedBeanType bean = (ManagedBeanType)aIt.next();
                        if (!this.isBeanScopeInMask(bean.getManagedBeanScope(), symbolScopeMask)) continue;
                        String name = bean.getManagedBeanName().getTextContent();
                        String detailedDescription = this.createAdditionalProposalInfo(bean);
                        IBeanInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
                        symbol.setName(name);
                        symbol.setDetailedDescription(detailedDescription);
                        try {
                            IJavaProject javaProject = JavaCore.create((IProject)iProject);
                            IType type = javaProject.findType(bean.getManagedBeanClass().getTextContent());
                            if (type != null) {
                                IJavaTypeDescriptor2 javaTypeDescriptor = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
                                javaTypeDescriptor.setType(type);
                                symbol.setJavaTypeDescriptor(javaTypeDescriptor);
                            }
                        }
                        catch (Throwable throwable) {}
                        symbols.add(symbol);
                    }
                }
                arrayList = symbols;
                Object var14_15 = null;
                if (artifact == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var14_16 = null;
                    if (artifact == null) break block8;
                    artifact.dispose();
                }
                throw throwable;
            }
            artifact.dispose();
        }
        return arrayList;
    }

    private String createAdditionalProposalInfo(ManagedBeanType beanType) {
        StringBuffer additionalInfo = new StringBuffer("<p><b>");
        additionalInfo.append("Name: </b>");
        additionalInfo.append(beanType.getManagedBeanName().getTextContent());
        additionalInfo.append("</p>");
        additionalInfo.append("<p><b>Type: </b>");
        additionalInfo.append(beanType.getManagedBeanClass().getTextContent());
        additionalInfo.append("</p>");
        additionalInfo.append("<p><b>Scope: </b>");
        additionalInfo.append(beanType.getManagedBeanScope().getTextContent());
        additionalInfo.append("</p>");
        StringBuffer descBuffer = new StringBuffer();
        Iterator it = beanType.getDescription().iterator();
        while (it.hasNext()) {
            DescriptionType descType = (DescriptionType)it.next();
            String appendString = descType.getTextContent();
            if (appendString == null) continue;
            descBuffer.append(appendString);
        }
        if (descBuffer.length() > 0) {
            additionalInfo.append("<p><b>Description: </b>");
            additionalInfo.append(descBuffer);
            additionalInfo.append("</p>");
        }
        return additionalInfo.toString();
    }

    private FacesConfigArtifactEdit getArtifact(IProject iProject) {
        return FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)iProject);
    }

    private boolean isBeanScopeInMask(ManagedBeanScopeType scope, int scopeMask) {
        int testScope = ISymbolConstants.getMaskForString((String)scope.getTextContent());
        if (testScope != -1) {
            return (scopeMask & testScope) != 0;
        }
        return false;
    }
}

