/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.IProjectJSFLibraryProvider;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.ProjectJSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.ProjectJSFLibraryMetaData;

public class ProjectJSFLibraryProvider
implements IProjectJSFLibraryProvider {
    private IProject fProject;
    private JSFLibraryRegistry jsfLibReg;
    private List colJSFImplLib;
    private List colJSFCompLib;
    private ProjectJSFLibraryMetaData model;

    public ProjectJSFLibraryProvider(IProject project) {
        this.fProject = project;
        this.jsfLibReg = JSFCorePlugin.getDefault().getJSFLibraryRegistry();
        this.model = new ProjectJSFLibraryMetaData(this);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public JSFLibraryRegistry getJSFLibraryRegistry() {
        return this.jsfLibReg;
    }

    public List getProjectJSFImplementationLibraries() {
        if (this.colJSFImplLib == null) {
            ArrayList<ProjectJSFLibrary> list = new ArrayList<ProjectJSFLibrary>();
            list.add(this.model.getSelectedJSFLibImplementation());
            this.colJSFImplLib = this.buildProjectJSFLibrary(this.jsfLibReg.getImplJSFLibraries(), list);
        }
        return this.colJSFImplLib;
    }

    public List getProjectJSFComponentLibraries() {
        if (this.colJSFCompLib == null) {
            this.colJSFCompLib = this.buildProjectJSFLibrary(this.jsfLibReg.getNonImplJSFLibraries(), this.model.getSelectedJSFLibComponent());
        }
        return this.colJSFCompLib;
    }

    public void saveModel(List selJSFLibImpl, List selJSFLibComp) {
        this.model.saveMetaData(selJSFLibImpl, selJSFLibComp);
        this.colJSFImplLib = null;
        this.colJSFCompLib = null;
    }

    public ProjectJSFLibrary getSelectedJSFImplementation() {
        return this.model.getSelectedJSFLibImplementation();
    }

    public List getSelectedJSFComponent() {
        return this.model.getSelectedJSFLibComponent();
    }

    private List buildProjectJSFLibrary(EList wsJSFLibs, List pjJSFLibs) {
        ArrayList<ProjectJSFLibrary> list = new ArrayList<ProjectJSFLibrary>(Collections.EMPTY_LIST);
        ProjectJSFLibrary prjJSFLib = null;
        Iterator it = wsJSFLibs.iterator();
        while (it.hasNext()) {
            JSFLibrary jsfLib = (JSFLibrary)it.next();
            Iterator itPrjLibs = pjJSFLibs.iterator();
            boolean selected = false;
            while (itPrjLibs.hasNext()) {
                prjJSFLib = (ProjectJSFLibrary)itPrjLibs.next();
                selected = prjJSFLib.getLibrary().getID().equals(jsfLib.getID());
                if (selected) break;
            }
            ProjectJSFLibrary newPrjJSFLib = selected && prjJSFLib != null ? prjJSFLib : new ProjectJSFLibrary(jsfLib, false, jsfLib.isDeployed());
            list.add(newPrjJSFLib);
        }
        return list;
    }
}

