/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.contentmodel.annotation;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.contentmodel.annotation.CMAnnotationAdvisor;
import org.eclipse.jst.jsf.core.internal.contentmodel.annotation.CMAnnotationFileInfo;
import org.eclipse.jst.jsf.core.internal.contentmodel.annotation.CMAnnotationMap;
import org.eclipse.jst.jsf.core.internal.provisional.contentmodel.annotation.CMAnnotationSourceFileLocator;
import org.eclipse.jst.jsf.core.internal.provisional.contentmodel.annotation.ICMAnnotationFileParser;
import org.osgi.framework.Bundle;

public class CMAnnotationFileParserHelper {
    private CMAnnotationFileInfo fileInfo;
    private static final String DEFAULT_PARSER_NAME = "org.eclipse.jst.jsf.core.internal.contentmodel.annotation.CMAnnotationFileParser";
    private static final String DEFAULT_LOCATOR_NAME = "org.eclipse.jst.jsf.core.internal.contentmodel.annotation.CMPluginRelativeSourceFileLocator";

    public CMAnnotationFileParserHelper(CMAnnotationFileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public void parse(CMAnnotationMap map) {
        ICMAnnotationFileParser parser = this.getParser();
        CMAnnotationAdvisor advisor = new CMAnnotationAdvisor(map, this.fileInfo);
        CMAnnotationSourceFileLocator locator = this.getLocator();
        map.setLocator(locator);
        try {
            parser.parse(advisor, locator);
        }
        catch (Exception e) {
            JSFCorePlugin.log(e, "Unable to parse: " + this.fileInfo.getAnnotationFileLocation() + " with " + this.fileInfo.getAnnotationFileLocatorClassname());
        }
    }

    private ICMAnnotationFileParser getParser() {
        String parserClassName = this.fileInfo.getParserClassName();
        Object obj = null;
        obj = parserClassName != null && !parserClassName.equals("") ? CMAnnotationFileParserHelper.getObjectForClassname(this.fileInfo.getBundleId(), parserClassName) : CMAnnotationFileParserHelper.getObjectForClassname("org.eclipse.jst.jsf.core", DEFAULT_PARSER_NAME);
        if (obj != null && obj instanceof ICMAnnotationFileParser) {
            return (ICMAnnotationFileParser)obj;
        }
        return null;
    }

    private CMAnnotationSourceFileLocator getLocator() {
        String locatorClassName = this.fileInfo.getAnnotationFileLocatorClassname();
        Object obj = null;
        obj = locatorClassName != null && !locatorClassName.equals("") ? CMAnnotationFileParserHelper.getObjectForClassname(this.fileInfo.getBundleId(), locatorClassName) : CMAnnotationFileParserHelper.getObjectForClassname("org.eclipse.jst.jsf.core", DEFAULT_LOCATOR_NAME);
        if (obj != null && obj instanceof CMAnnotationSourceFileLocator) {
            CMAnnotationSourceFileLocator locator = (CMAnnotationSourceFileLocator)obj;
            locator.setFileInfo(this.fileInfo);
            return locator;
        }
        return null;
    }

    private static Object getObjectForClassname(String bundleId, String providerClassName) {
        Bundle bundle;
        block6: {
            bundle = Platform.getBundle((String)bundleId);
            if (bundle != null) break block6;
            JSFCorePlugin.log(4, CMAnnotationFileParserHelper.getMsg(bundleId, providerClassName, "Unable to find bundleId: "));
            return null;
        }
        try {
            Class klass = bundle.loadClass(providerClassName);
            if (klass != null) {
                return klass.newInstance();
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            JSFCorePlugin.log(e, CMAnnotationFileParserHelper.getMsg(bundleId, providerClassName, "ClassNotFoundException: "));
        }
        catch (InstantiationException e) {
            JSFCorePlugin.log(e, CMAnnotationFileParserHelper.getMsg(bundleId, providerClassName, "InstantiationException: "));
        }
        catch (IllegalAccessException e) {
            JSFCorePlugin.log(e, CMAnnotationFileParserHelper.getMsg(bundleId, providerClassName, "IllegalAccessException: "));
        }
        return null;
    }

    private static String getMsg(String bundleId, String providerClassName, String prefix) {
        StringBuffer buf = new StringBuffer(prefix);
        buf.append(providerClassName).append(" in ").append(bundleId);
        return buf.toString();
    }
}

