/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.contentmodel.annotation.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.CMAnnotationFileInfo;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.CMAnnotationFileParserHelper;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.CMAnnotationFileRegistryReader;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.CMAnnotationMap;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.Messages;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.provisional.ICMAnnotationSourceFileInfo;
import org.eclipse.jst.jsf.contentmodel.annotations.Activator;
import org.eclipse.osgi.util.NLS;

public final class CMAnnotationFileRegistry {
    private Map annotationFilesMap = new HashMap(1);
    private Map parsedFilesMap = new HashMap(1);
    private static CMAnnotationFileRegistry reg;

    public static CMAnnotationFileRegistry getInstance() {
        if (reg == null) {
            reg = new CMAnnotationFileRegistry();
        }
        return reg;
    }

    private CMAnnotationFileRegistry() {
        new CMAnnotationFileRegistryReader(this).readRegistry();
    }

    private synchronized List getAnnotationFilesInfos(String uri) {
        List theList = (List)this.annotationFilesMap.get(uri);
        return theList != null ? theList : new ArrayList();
    }

    public synchronized void addAnnotationFileInfo(String uri, ICMAnnotationSourceFileInfo fileInfo) {
        ArrayList<ICMAnnotationSourceFileInfo> fileInfos = (ArrayList<ICMAnnotationSourceFileInfo>)this.annotationFilesMap.get(uri);
        if (fileInfos == null) {
            fileInfos = new ArrayList<ICMAnnotationSourceFileInfo>();
            this.annotationFilesMap.put(uri, fileInfos);
        }
        fileInfos.add(fileInfo);
    }

    private synchronized void addParsedFileToMap(String uri, CMAnnotationMap map) {
        ArrayList<CMAnnotationMap> maps = (ArrayList<CMAnnotationMap>)this.parsedFilesMap.get(uri);
        if (maps == null) {
            maps = new ArrayList<CMAnnotationMap>();
            this.parsedFilesMap.put(uri, maps);
        }
        maps.add(map);
    }

    public synchronized List getAnnotationMaps(String uri) {
        List list = (List)this.parsedFilesMap.get(uri);
        if (list == null) {
            this.loadAnnotationsForGrammar(uri);
            list = (List)this.parsedFilesMap.get(uri);
        }
        return list;
    }

    public boolean hasAnnotations(String bundleId, String uri) {
        List maps = (List)this.annotationFilesMap.get(uri);
        if (maps == null || maps.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < maps.size()) {
            if (((ICMAnnotationSourceFileInfo)maps.get(i)).getBundleId().equals(bundleId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasAnnotations(String uri) {
        return this.annotationFilesMap.get(uri) != null;
    }

    private boolean areAnnotationsParsed(String uri) {
        return this.hasAnnotations(uri) && this.parsedFilesMap.get(uri) != null;
    }

    private void loadAnnotationsForGrammar(String uri) {
        if (this.areAnnotationsParsed(uri)) {
            return;
        }
        List annotationFiles = this.getAnnotationFilesInfos(uri);
        Iterator i = annotationFiles.iterator();
        while (i.hasNext()) {
            try {
                CMAnnotationFileInfo annotationFileInfo = (CMAnnotationFileInfo)i.next();
                CMAnnotationMap map = new CMAnnotationMap(annotationFileInfo);
                CMAnnotationFileParserHelper parserHelper = new CMAnnotationFileParserHelper();
                parserHelper.parse(map);
                this.addParsedFileToMap(uri, map);
            }
            catch (Exception e) {
                Activator.log(e, NLS.bind((String)Messages.CMAnnotationFileRegistry_load_error, (Object[])new String[]{uri}));
            }
        }
    }
}

