/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import java.util.Iterator;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.preference.BaseFigureDecorator;
import org.eclipse.jst.jsf.facesconfig.ui.preference.BaseNodeFigure;
import org.eclipse.jst.jsf.facesconfig.ui.preference.CompoundFigureListener;
import org.eclipse.jst.jsf.facesconfig.ui.preference.IContainerFigure;
import org.eclipse.jst.jsf.facesconfig.ui.preference.IconFigure;
import org.eclipse.jst.jsf.facesconfig.ui.preference.TabbedTitleBarBorder;
import org.eclipse.jst.jsf.facesconfig.ui.preference.TitleBarButton;
import org.eclipse.jst.jsf.facesconfig.ui.preference.WindowFigure;
import org.eclipse.jst.jsf.facesconfig.ui.preference.WindowFreeformHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class CompoundNodeFigure
extends BaseNodeFigure
implements FreeformFigure,
IContainerFigure {
    public static final int MINIMIZED = 1;
    public static final int RESTORED = 2;
    public static final int MAXIMIZED = 3;
    private int state = 2;
    private TitleBarButton minButton;
    private TitleBarButton maxButton;
    private IconFigure iconFigure;
    private WindowFigure windowFigure;
    private static String DEFAULT_NAME = "CompoundNode";
    private static String DEFAULT_ICON = "editor/CompoundNode.gif";
    private static Image minimizeImage = EditorPlugin.getDefault().getImage("minimize.gif");
    private static Image minimizeHiliteImage = EditorPlugin.getDefault().getImage("minimize_hilite.gif");
    private static Image maximizeImage = EditorPlugin.getDefault().getImage("maximize.gif");
    private static Image maximizeHiliteImage = EditorPlugin.getDefault().getImage("maximize_hilite.gif");
    private static Image restoreImage = EditorPlugin.getDefault().getImage("restore.gif");
    private static Image restoreHiliteImage = EditorPlugin.getDefault().getImage("restore_hilite.gif");
    private WindowFreeformHelper helper = new WindowFreeformHelper(this);
    static /* synthetic */ Class class$0;

    public CompoundNodeFigure() {
        super(new IconFigure(DEFAULT_NAME, EditorPlugin.getDefault().getImage(DEFAULT_ICON)));
        this.iconFigure = (IconFigure)this.getBaseFigure();
        this.windowFigure = new WindowFigure();
        this.windowFigure.setForegroundColor(IconFigure.defaultForegroundColor);
        this.windowFigure.setFont(IconFigure.defaultFont);
        this.minButton = new TitleBarButton(minimizeImage, minimizeHiliteImage, null, null);
        this.maxButton = new TitleBarButton(maximizeImage, maximizeHiliteImage, restoreImage, restoreHiliteImage);
        this.add((IFigure)this.minButton);
        this.add((IFigure)this.maxButton);
        this.minButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                CompoundNodeFigure.this.setState(1);
            }
        });
        this.maxButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                CompoundNodeFigure.this.setState(CompoundNodeFigure.this.maxButton.getState() ? 3 : 2);
            }
        });
        this.showIcon();
    }

    public void setOpaque(boolean flag) {
        this.windowFigure.setOpaque(flag);
    }

    private void showIcon() {
        this.setVisible(false);
        this.minButton.setVisible(false);
        this.maxButton.setVisible(false);
        super.setBaseFigure(this.iconFigure);
        this.setAnchorsVisible(true);
        this.setVisible(true);
    }

    private void showWindow() {
        this.setVisible(false);
        if (this.state == 2) {
            super.setBaseFigure(this.windowFigure);
            this.minButton.setVisible(true);
            this.minButton.setState(false);
            this.minButton.setToolTip((IFigure)new Label("Minimize"));
            this.maxButton.setVisible(true);
            this.maxButton.setState(false);
            this.maxButton.setToolTip((IFigure)new Label("Maximize"));
            this.setAnchorsVisible(true);
        } else if (this.state == 3) {
            this.setAnchorsVisible(false);
            Rectangle constraint = new Rectangle(0, 0, -1, -1);
            IFigure parent = this.getParent();
            if (parent != null) {
                constraint = parent.getBounds().getCopy();
                constraint.width += constraint.x;
                constraint.height += constraint.y;
                constraint.x = 0;
                constraint.y = 0;
            }
            super.setBaseFigure(this.windowFigure, constraint);
            if (parent != null && parent.getLayoutManager() != null) {
                parent.getLayoutManager().setConstraint((IFigure)this, (Object)constraint);
            }
            this.minButton.setVisible(false);
            this.maxButton.setVisible(true);
            this.maxButton.setState(true);
            this.maxButton.setToolTip((IFigure)new Label("Restore"));
        }
        this.setVisible(true);
    }

    public void addDecorator(BaseFigureDecorator decorator) {
        this.iconFigure.addDecorator(decorator);
    }

    public void removeDecorator() {
        this.iconFigure.removeDecorator();
    }

    public void removeDecorator(int position) {
        this.iconFigure.removeDecorator(position);
    }

    public void setHilight(boolean flag) {
        this.windowFigure.setHighlight(flag);
        if (flag) {
            this.moveToTop();
        }
    }

    public void setText(String name) {
        this.iconFigure.setText(name);
        this.windowFigure.setText(name);
    }

    public void setIcon(Image image) {
        this.iconFigure.setIcon(image);
    }

    public void setToolTipText(String text) {
        this.iconFigure.setToolTipText(text);
    }

    public void validate() {
        LayoutManager layout = this.getLayoutManager();
        if (this.state != 1) {
            if (this.state == 2) {
                Rectangle r = this.windowFigure.getBounds().getCopy();
                Insets i = this.windowFigure.getInsets();
                Dimension dm = this.maxButton.getSize();
                Insets p = this.windowFigure.getTabbedTitleBarBorder().getPadding();
                layout.setConstraint((IFigure)this.maxButton, (Object)new Rectangle(r.x + r.width - dm.width - p.right - i.right, r.y + p.top + i.top - dm.height - i.bottom, -1, -1));
                layout.setConstraint((IFigure)this.minButton, (Object)new Rectangle(r.x + r.width - 2 * dm.width - 2 * p.right - i.right, r.y + p.top + i.top - dm.height - i.bottom, -1, -1));
            } else if (this.state == 3) {
                if (this.getParent() == null) {
                    return;
                }
                Rectangle r = this.getParent().getBounds().getCopy();
                Insets i = this.windowFigure.getInsets();
                Dimension dm = this.maxButton.getSize();
                Insets p = this.windowFigure.getTabbedTitleBarBorder().getPadding();
                layout.setConstraint((IFigure)this.maxButton, (Object)new Rectangle(r.x + r.width - dm.width - p.right - i.right, r.y + p.top, -1, -1));
            }
        }
        super.validate();
    }

    public IconFigure getIconFigure() {
        return this.iconFigure;
    }

    public WindowFigure getWindowFigure() {
        return this.windowFigure;
    }

    public void setFont(Font f) {
        this.iconFigure.setFont(f);
        this.windowFigure.setFont(f);
    }

    public void setForegroundColor(Color c) {
        this.iconFigure.setForegroundColor(c);
        this.windowFigure.setForegroundColor(c);
    }

    public void setBackgroundColor(Color c) {
        this.iconFigure.setBackgroundColor(c);
        this.windowFigure.setBackgroundColor(c);
    }

    public int getState() {
        return this.state;
    }

    public void setState(int newState) {
        int oldState = this.state;
        this.state = newState;
        if (this.state == 1) {
            if (this.getParent() != null && this.getParent().getLayoutManager() != null) {
                Rectangle constraint = (Rectangle)this.getParent().getLayoutManager().getConstraint((IFigure)this);
                constraint.width = -1;
                constraint.height = -1;
            }
            this.showIcon();
        } else if (this.state == 3) {
            if (this.getParent() != null && this.getParent().getLayoutManager() != null) {
                Rectangle constraint = (Rectangle)this.getParent().getLayoutManager().getConstraint((IFigure)this);
                constraint.x = 0;
                constraint.y = 0;
                constraint.width = -1;
                constraint.height = -1;
            }
            this.showWindow();
        } else if (this.state == 2) {
            if (this.getParent() != null && this.getParent().getLayoutManager() != null) {
                Rectangle constraint = (Rectangle)this.getParent().getLayoutManager().getConstraint((IFigure)this);
                constraint.setSize(this.windowFigure.getBounds().getSize());
            }
            this.showWindow();
        }
        this.fireStateChanged(oldState, newState);
    }

    protected void fireStateChanged(int oldState, int newState) {
        Object[] l = this.windowFigure.getTabbedTitleBarBorder().getListeners();
        int i = 0;
        while (i < l.length) {
            if (l[i] instanceof CompoundFigureListener) {
                ((CompoundFigureListener)l[i]).stateChanged(oldState, newState);
            }
            ++i;
        }
    }

    public Point getScrollPosition() {
        return this.windowFigure.getScrollPosition();
    }

    public int addTab(String s) {
        return this.windowFigure.addTab(s);
    }

    public void removeTab(int index) {
        this.windowFigure.removeTab(index);
    }

    public void setCurrentTab(int index) {
        this.windowFigure.setCurrentTab(index);
    }

    public int getCurrentTab() {
        return this.windowFigure.getCurrentTab();
    }

    public void setContents(int index, Object contents) {
        this.windowFigure.setContents(index, contents);
    }

    public Object getContents(int index) {
        return this.windowFigure.getContents(index);
    }

    public Object getContents() {
        return this.windowFigure.getContents();
    }

    public TabbedTitleBarBorder getTabbedTitleBarBorder() {
        return this.windowFigure.getTabbedTitleBarBorder();
    }

    public void addCompoundFigureListener(CompoundFigureListener listener) {
        this.windowFigure.getTabbedTitleBarBorder().addTabbedWindowListener(listener);
    }

    public void removeCompoundFigureListener(CompoundFigureListener listener) {
        this.windowFigure.getTabbedTitleBarBorder().removeTabbedWindowListener(listener);
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        if (this.getState() == 2) {
            Dimension d = this.windowFigure.getMinimumSize(wHint, hHint);
            d.width += this.minButton.getSize().width + this.maxButton.getSize().width + 2 * this.windowFigure.getTabbedTitleBarBorder().getPadding().getWidth();
            return d;
        }
        if (this.getState() == 1) {
            return this.iconFigure.getMinimumSize(wHint, hHint);
        }
        return super.getMinimumSize(wHint, hHint);
    }

    public void addFreeformListener(FreeformListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.draw2d.FreeformListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addListener(clazz, listener);
    }

    public void fireExtentChanged() {
        if (this.state == 3) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.draw2d.FreeformListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Iterator iter = this.getListeners(clazz);
            while (iter.hasNext()) {
                ((FreeformListener)iter.next()).notifyFreeformExtentChanged();
            }
        }
    }

    public Rectangle getFreeformExtent() {
        if (this.state == 3) {
            return this.helper.getFreeformExtent();
        }
        return this.getBounds();
    }

    public void removeFreeformListener(FreeformListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.draw2d.FreeformListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.removeListener(clazz, listener);
    }

    public void setFreeformBounds(Rectangle bounds) {
        if (this.getState() == 3) {
            this.helper.setFreeformBounds(bounds);
        }
    }

    public Layer getLayer(Object key) {
        if (this.windowFigure != null && this.windowFigure.isVisible()) {
            return this.windowFigure.getLayer(key);
        }
        return null;
    }
}

