/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.dialog;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.ClassButtonDialogField;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.DialogField;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.IStringButtonAdapter;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.StringButtonDialogField;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.StringDialogField;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.dialog.ComponentListDialog;
import org.eclipse.jst.jsf.facesconfig.ui.page.IFacesConfigPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class AddEditRendererDialog
extends Dialog {
    private static final int MIN_DIALOG_WIDTH = 300;
    private StringDialogField rendererNameField;
    private ClassButtonDialogField rendererClassField;
    private StringButtonDialogField componentFamilyField;
    private StringDialogField renderTypeField;
    private IProject project;
    private String rendererName;
    private String rendererClass;
    private String componentFamily;
    private String rendererType;
    private boolean isNew;
    private IFacesConfigPage page;

    public AddEditRendererDialog(Shell parentShell, IFacesConfigPage page, boolean isNew) {
        super(parentShell);
        this.page = page;
        this.isNew = isNew;
    }

    public AddEditRendererDialog(Shell parentShell, String rendererName, String rendererClass, String componentFamily, String renderType) {
        super(parentShell);
        this.rendererName = rendererName;
        this.rendererClass = rendererClass;
        this.componentFamily = componentFamily;
        this.rendererType = renderType;
        this.isNew = false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.isNew) {
            newShell.setText(EditorMessages.RendererSection_Dialog_Title_Add);
        } else {
            newShell.setText(EditorMessages.RendererSection_Dialog_Title_Edit);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        TabFolder tabFolder = new TabFolder(container, 4);
        tabFolder.setLayoutData((Object)gd);
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText(EditorMessages.RendererSection_Dialog_Tab_General);
        Control control = this.createGeneralTabControl((Composite)generalTabItem.getParent());
        generalTabItem.setControl(control);
        return container;
    }

    private Control createGeneralTabControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        composite.setFont(parent.getFont());
        this.rendererNameField = new StringDialogField();
        this.rendererNameField.setLabelText(EditorMessages.RendererSection_Dialog_DisplayName);
        this.rendererClassField = new ClassButtonDialogField(this.getProject());
        this.rendererClassField.setLabelText(EditorMessages.RendererSection_Dialog_RendererClass);
        this.rendererClassField.setProject(this.getProject());
        this.rendererClassField.setSuperClassName("javax.faces.render.Renderer");
        this.rendererClassField.setAutoOpenResource(false);
        this.componentFamilyField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                Shell shell = EditorPlugin.getActiveShell();
                ComponentListDialog dialog = new ComponentListDialog(shell, AddEditRendererDialog.this.page, AddEditRendererDialog.this.page.getInput(), EditorMessages.RendererSection_Dialog_ComponentFamilyCaption, EditorMessages.RendererSection_Dialog_ComponentFamilyLabel);
                if (dialog.open() == 0) {
                    AddEditRendererDialog.this.componentFamilyField.setText(dialog.getValue());
                }
            }
        });
        this.componentFamilyField.setLabelText(EditorMessages.RendererSection_Dialog_ComponentFamilyValue);
        this.renderTypeField = new StringDialogField();
        this.renderTypeField.setLabelText(EditorMessages.RendererSection_Dialog_TypeValue);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        int numberOfColumns = 4;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        composite.setLayout((Layout)gl);
        this.rendererNameField.doFillIntoGrid(null, composite, numberOfColumns);
        this.componentFamilyField.doFillIntoGrid(null, composite, numberOfColumns);
        this.renderTypeField.doFillIntoGrid(null, composite, numberOfColumns);
        this.rendererClassField.doFillIntoGrid(null, composite, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.rendererClassField.getTextControl(null, composite));
        this.rendererNameField.setText(this.rendererName);
        this.rendererClassField.setText(this.rendererClass);
        this.componentFamilyField.setText(this.componentFamily);
        this.renderTypeField.setText(this.rendererType);
        return composite;
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(300), shellSize.x), shellSize.y);
    }

    public IProject getProject() {
        return this.project;
    }

    protected void okPressed() {
        this.rendererName = this.rendererNameField.getText();
        this.rendererClass = this.rendererClassField.getText();
        this.componentFamily = this.componentFamilyField.getText();
        this.rendererType = this.renderTypeField.getText();
        super.okPressed();
    }

    public String getRendererClass() {
        return this.rendererClass;
    }

    public void setRendererClass(String rendererClass) {
        this.rendererClass = rendererClass;
    }

    public String getRendererName() {
        return this.rendererName;
    }

    public void setRendererName(String rendererName) {
        this.rendererName = rendererName;
    }

    public String getComponentFamily() {
        return this.componentFamily;
    }

    public void setComponentFamily(String componentFamily) {
        this.componentFamily = componentFamily;
    }

    public String getRendererType() {
        return this.rendererType;
    }

    public void setRendererType(String rendererType) {
        this.rendererType = rendererType;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

