/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryDecorator;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.project.facet.IJSFFacetInstallDataModelProperties;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class JSFFacetInstallDataModelProvider
extends FacetInstallDataModelProvider
implements IJSFFacetInstallDataModelProperties {
    private String errorMessage;
    private IPath webContentPath;

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("IJSFFacetInstallDataModelProperties.IMPLEMENTATION");
        names.add("IJSFFacetInstallDataModelProperties.DEPLOY_IMPLEMENTATION");
        names.add("IJSFFacetInstallDataModelProperties.CONFIG_PATH");
        names.add("IJSFFacetInstallDataModelProperties.SERVLET_NAME");
        names.add("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS");
        names.add("IJSFFacetInstallDataModelProperties.WEBCONTENT_DIR");
        names.add("IJSFFacetInstallDataModelProperties.IMPLEMENTATION_LIBRARIES");
        names.add("IJSFFacetInstallDataModelProperties.COMPONENT_LIBRARIES");
        names.add("IJSFFacetInstallDataModelProperties.DEFAULT_IMPLEMENTATION_LIBRARY");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.IMPLEMENTATION")) {
            if (JSFCorePlugin.getDefault().getJSFLibraryRegistry() == null) {
                return null;
            }
            return JSFCorePlugin.getDefault().getJSFLibraryRegistry().getDefaultImplementation();
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.DEPLOY_IMPLEMENTATION")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.CONFIG_PATH")) {
            return "/WEB-INF/faces-config.xml";
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.SERVLET_NAME")) {
            return "Faces Servlet";
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS")) {
            return new String[]{"*.faces"};
        }
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "jst.jsf";
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.WEBCONTENT_DIR")) {
            return "WebContent";
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.COMPONENT_LIBRARIES")) {
            return this.getDefaultJSFComponentLibraries();
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.IMPLEMENTATION_LIBRARIES")) {
            return this.getDefaultJSFImplementationLibraries();
        }
        if (propertyName.equals("IJSFFacetInstallDataModelProperties.DEFAULT_IMPLEMENTATION_LIBRARY")) {
            return this.getDefaultImplementationLibrary();
        }
        return super.getDefaultProperty(propertyName);
    }

    public IStatus validate(String name) {
        this.errorMessage = null;
        if (name.equals("IJSFFacetInstallDataModelProperties.IMPLEMENTATION") && this.getBooleanProperty("IJSFFacetInstallDataModelProperties.DEPLOY_IMPLEMENTATION")) {
            return this.validateImpl((JSFLibrary)this.getProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION"));
        }
        if (name.equals("IJSFFacetInstallDataModelProperties.CONFIG_PATH")) {
            return this.validateConfigLocation(this.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH"));
        }
        if (name.equals("IJSFFacetInstallDataModelProperties.SERVLET_NAME")) {
            return this.validateServletName(this.getStringProperty("IJSFFacetInstallDataModelProperties.SERVLET_NAME"));
        }
        return super.validate(name);
    }

    private IStatus validateServletName(String servletName) {
        if (servletName == null || servletName.trim().length() == 0) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateServletName;
            return WTPCommonPlugin.createErrorStatus((String)this.errorMessage);
        }
        return OK_STATUS;
    }

    private IStatus validateImpl(JSFLibrary impl) {
        if (impl == null) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateJSFImpl;
        }
        if (this.errorMessage != null) {
            return WTPCommonPlugin.createErrorStatus((String)this.errorMessage);
        }
        return OK_STATUS;
    }

    private IStatus validateConfigLocation(String text) {
        if (text == null || text.trim().equals("")) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileEmpty;
            return WTPCommonPlugin.createErrorStatus((String)this.errorMessage);
        }
        text = text.trim();
        if (this.getProjectPath() == null) {
            return OK_STATUS;
        }
        IPath fullPath = this.getProjectPath().append(text);
        Path passedPath = new Path(text);
        if (!fullPath.isValidPath(text)) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateConfigFilePath;
            return WTPCommonPlugin.createErrorStatus((String)this.errorMessage);
        }
        if (text.toLowerCase().lastIndexOf(".xml") != text.length() - 4) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileXML;
            return WTPCommonPlugin.createErrorStatus((String)this.errorMessage);
        }
        if (text.lastIndexOf("\\") >= 0) {
            this.errorMessage = Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileSlashes;
            return WTPCommonPlugin.createErrorStatus((String)this.errorMessage);
        }
        if (passedPath.getDevice() != null) {
            this.errorMessage = NLS.bind((String)Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileRelative1, (Object)this.getWebContentFolder().removeFirstSegments(this.getWebContentFolder().segmentCount() - 1).toString());
            return WTPCommonPlugin.createErrorStatus((String)this.errorMessage);
        }
        IPath setPath = this.getWebContentFolder().append((IPath)passedPath);
        if (!this.getWebContentFolder().isPrefixOf(setPath)) {
            this.errorMessage = NLS.bind((String)Messages.JSFFacetInstallDataModelProvider_ValidateConfigFileRelative2, (Object)this.getWebContentFolder().removeFirstSegments(this.getWebContentFolder().segmentCount() - 1).toString());
            return WTPCommonPlugin.createErrorStatus((String)this.errorMessage);
        }
        return OK_STATUS;
    }

    private IPath getProjectPath() {
        String projName = (String)this.getProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        if (project.exists()) {
            return project.getLocation();
        }
        IDataModel projModel = (IDataModel)this.getProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM");
        if (projModel.getBooleanProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION")) {
            return new Path(projModel.getStringProperty("IProjectCreationPropertiesNew.PROJECT_LOCATION")).append(projName);
        }
        return new Path(projModel.getStringProperty("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION")).append(projName);
    }

    private IPath getWebContentFolder() {
        IPath iPath;
        block6: {
            WebArtifactEdit webApp;
            block4: {
                IPath iPath2;
                block5: {
                    if (this.webContentPath != null) {
                        return this.webContentPath;
                    }
                    webApp = null;
                    try {
                        String projName = this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
                        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
                        webApp = JSFUtils.getWebArtifactEditForRead(proj);
                        if (webApp == null) break block4;
                        iPath2 = this.webContentPath = JSFUtils.getWebArtifactEditForRead(proj).getDeploymentDescriptorPath().removeLastSegments(2);
                        Object var4_6 = null;
                        if (webApp == null) break block5;
                    }
                    catch (Throwable throwable) {
                        block7: {
                            Object var4_8 = null;
                            if (webApp == null) break block7;
                            webApp.dispose();
                        }
                        throw throwable;
                    }
                    webApp.dispose();
                }
                return iPath2;
            }
            iPath = this.webContentPath = new Path(this.getStringProperty("IJSFFacetInstallDataModelProperties.WEBCONTENT_DIR"));
            Object var4_7 = null;
            if (webApp == null) break block6;
            webApp.dispose();
        }
        return iPath;
    }

    private List getDefaultJSFComponentLibraries() {
        ArrayList<JSFLibraryDecorator> list = new ArrayList<JSFLibraryDecorator>(Collections.EMPTY_LIST);
        JSFLibraryDecorator prjJSFLib = null;
        JSFLibrary jsfLib = null;
        if (JSFCorePlugin.getDefault().getJSFLibraryRegistry() != null) {
            Iterator it = JSFCorePlugin.getDefault().getJSFLibraryRegistry().getNonImplJSFLibraries().iterator();
            while (it.hasNext()) {
                jsfLib = (JSFLibrary)it.next();
                prjJSFLib = new JSFLibraryDecorator(jsfLib, true, true);
                list.add(prjJSFLib);
            }
        }
        return list;
    }

    private List getDefaultJSFImplementationLibraries() {
        ArrayList<JSFLibraryDecorator> list = new ArrayList<JSFLibraryDecorator>(Collections.EMPTY_LIST);
        if (JSFCorePlugin.getDefault().getJSFLibraryRegistry() != null) {
            JSFLibrary jsfLib = JSFCorePlugin.getDefault().getJSFLibraryRegistry().getDefaultImplementation();
            JSFLibraryDecorator prjJSFLib = new JSFLibraryDecorator(jsfLib, true, true);
            list.add(prjJSFLib);
        }
        return list;
    }

    private JSFLibraryDecorator getDefaultImplementationLibrary() {
        if (JSFCorePlugin.getDefault().getJSFLibraryRegistry() != null) {
            JSFLibrary jsfLib = JSFCorePlugin.getDefault().getJSFLibraryRegistry().getDefaultImplementation();
            return new JSFLibraryDecorator(jsfLib, true, true);
        }
        return null;
    }
}

