/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.taglibprocessing.internal.provisional.attributevalues;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.provisional.CMAnnotationHelper;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.provisional.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.provisional.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.JSFAppConfigManager;
import org.eclipse.jst.jsf.core.internal.types.CompositeType;
import org.eclipse.jst.jsf.facesconfig.edit.provider.FacesConfigEditPlugin;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.AbstractMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.ELIsNotValidException;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.IPossibleValues;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.IValidELValues;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.IValidValues;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.IValidationMessage;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.PossibleValue;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.ValidationMessage;
import org.osgi.framework.Bundle;

public abstract class FacesConfigIdentifierFeatures
extends AbstractMetaDataEnabledFeature
implements IPossibleValues,
IValidValues,
IValidELValues {
    public static final String ID_TYPE_PROP_NAME = "config-type";
    protected static final ImageDescriptor MISSING_IMAGE = ImageDescriptor.getMissingImageDescriptor();
    protected String imageName;
    private ImageDescriptor imageDescriptor;
    protected List validationMessages;

    public List getPossibleValues() {
        ArrayList ret = new ArrayList();
        List idTypes = this.getConfigTypes();
        if (idTypes != null) {
            int i = 0;
            while (i < idTypes.size()) {
                if (this.getReturnType().equals((String)idTypes.get(i))) {
                    ret.addAll(this.createPossibleValues());
                }
                ++i;
            }
        }
        return ret;
    }

    public boolean isValidValue(String value) {
        List idTypes = this.getConfigTypes();
        if (idTypes != null) {
            int i = 0;
            while (i < idTypes.size()) {
                if (this.getReturnType().equals((String)idTypes.get(i))) {
                    if (this.hasValue(this.getElementIDs(this.getJSFAppConfigMgr()), value)) {
                        this.getValidationMessages().clear();
                        return true;
                    }
                    this.getValidationMessages().add(this.getValidationMessage(value));
                }
                ++i;
            }
        }
        return false;
    }

    private boolean hasValue(List elements, String value) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            if (!value.equals((String)it.next())) continue;
            return true;
        }
        return false;
    }

    protected abstract String getMyValidationMessage(String var1);

    protected IValidationMessage getValidationMessage(String value) {
        String msg = this.getCMValidationMessage();
        if (msg == null) {
            msg = this.getMyValidationMessage(value);
        }
        String code = this.getCMValidationCode();
        int severity = this.getCMValidationSeverity();
        ValidationMessage valMsg = new ValidationMessage(msg, code, severity);
        return valMsg;
    }

    protected String singleQuote(String value) {
        return "'" + value + "'";
    }

    public List getValidationMessages() {
        if (this.validationMessages == null) {
            this.validationMessages = new ArrayList();
        }
        return this.validationMessages;
    }

    protected abstract List getElements(JSFAppConfigManager var1);

    protected abstract List getPossibleValueProposals(List var1);

    protected abstract String getImageName();

    private List createPossibleValues() {
        return this.getPossibleValueProposals(this.getElements(this.getJSFAppConfigMgr()));
    }

    protected ImageDescriptor getImage() {
        ImageDescriptor ret = super.getImage();
        if (ret != null && ret != MISSING_IMAGE) {
            return ret;
        }
        if (this.imageDescriptor == null) {
            this.imageDescriptor = this.getImageDesc(this.getImageName());
        }
        return this.imageDescriptor;
    }

    private ImageDescriptor getImageDesc(String img) {
        ImageDescriptor desc;
        block3: {
            try {
                Bundle bundle = FacesConfigEditPlugin.getPlugin().getBundle();
                URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(img), null);
                desc = ImageDescriptor.createFromURL((URL)url);
                if (desc != MISSING_IMAGE) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return desc;
    }

    protected PossibleValue createProposal(String value, EList displayName, EList description) {
        String display = value;
        if (displayName.size() > 0) {
            DisplayNameType displayNameType = (DisplayNameType)displayName.get(0);
            display = displayNameType.getTextContent();
        }
        String desc = null;
        if (description.size() > 0) {
            DescriptionType descType = (DescriptionType)description.get(0);
            desc = descType.getTextContent();
        }
        PossibleValue pv = new PossibleValue(value, display);
        if (desc != null) {
            pv.setAdditionalInformation(desc);
        }
        return pv;
    }

    private List getConfigTypes() {
        return CMAnnotationHelper.getCMAttributePropertyValues((String)this.getCMAnnotationContext().getBundleId(), (String)this.getCMAnnotationContext().getUri(), (String)this.getCMAnnotationContext().getElementName(), (String)this.getCMAnnotationContext().getAttributeName(), (String)ID_TYPE_PROP_NAME);
    }

    private JSFAppConfigManager getJSFAppConfigMgr() {
        return JSFAppConfigManager.getInstance((IProject)this.getProject());
    }

    private IProject getProject() {
        IWorkspaceContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(this.getStructuredDocumentContext());
        if (resolver != null) {
            return resolver.getProject();
        }
        return null;
    }

    protected abstract List getElementIDs(JSFAppConfigManager var1);

    protected abstract String getReturnType();

    protected int getAssignmentType() {
        return 0;
    }

    public CompositeType getExpectedRuntimeType() throws ELIsNotValidException {
        String type = Signature.createTypeSignature((String)this.getReturnType(), (boolean)true);
        return new CompositeType(type, this.getAssignmentType());
    }

    protected String getCMValidationMessage() {
        return this.getCMAttributePropertyValue("valid-values-message");
    }

    protected int getCMValidationSeverity() {
        String val = this.getCMAttributePropertyValue("valid-values-severity");
        if (val == null) {
            return 2;
        }
        int severity = Integer.valueOf(val);
        return severity;
    }

    protected String getCMValidationCode() {
        return this.getCMAttributePropertyValue("valid-values-code");
    }
}

