/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import java.io.IOException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddDocumentationCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AnnotationSection
extends AbstractSection {
    Text simpleText;

    public void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.simpleText = this.getWidgetFactory().createText(this.composite, "", 768);
        this.simpleText.addListener(24, (Listener)this);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 1);
        data.right = new FormAttachment(100, -1);
        data.top = new FormAttachment(0, 1);
        data.bottom = new FormAttachment(100, -1);
        this.simpleText.setLayoutData((Object)data);
    }

    public void refresh() {
        super.refresh();
        this.setListenerEnabled(false);
        if (this.input instanceof XSDConcreteComponent) {
            XSDAnnotation xsdAnnotation = XSDCommonUIUtils.getInputXSDAnnotation((XSDConcreteComponent)this.input, false);
            this.setInitialText(xsdAnnotation);
        }
        this.setListenerEnabled(true);
    }

    public void doHandleEvent(Event event) {
        if (this.input instanceof XSDConcreteComponent && event.widget == this.simpleText) {
            AddDocumentationCommand command = new AddDocumentationCommand(Messages._UI_ACTION_ADD_DOCUMENTATION, null, (XSDConcreteComponent)this.input, this.simpleText.getText(), "");
            this.getCommandStack().execute((Command)command);
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void dispose() {
    }

    private void setInitialText(XSDAnnotation an) {
        if (an != null) {
            try {
                Element docElement;
                EList documentationList = an.getUserInformation();
                if (documentationList.size() > 0 && (docElement = (Element)documentationList.get(0)) != null) {
                    this.simpleText.setText(this.doSerialize(docElement));
                }
            }
            catch (Exception exception) {}
        } else {
            this.simpleText.setText("");
        }
    }

    private String doSerialize(Element element) throws IOException {
        String source = "";
        Node firstChild = element.getFirstChild();
        Node lastChild = element.getLastChild();
        int start = 0;
        int end = 0;
        if (element instanceof IDOMElement) {
            IDOMElement domElement = (IDOMElement)element;
            IDOMModel model = domElement.getModel();
            IDOMDocument doc = model.getDocument();
            if (firstChild instanceof IDOMNode) {
                IDOMNode first = (IDOMNode)firstChild;
                start = first.getStartOffset();
            }
            if (lastChild instanceof IDOMNode) {
                IDOMNode last = (IDOMNode)lastChild;
                end = last.getEndOffset();
            }
            source = doc.getSource().substring(start, end);
        }
        return source;
    }
}

