/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.SpecificationForExtensionsSchema;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddExtensibilityElementCommand
extends Command {
    Element input;
    Element elementToAdd;
    SpecificationForExtensionsSchema extensionSchemaSpec;

    public AddExtensibilityElementCommand(String label, Element input, Element elementToAdd) {
        super(label);
        this.input = input;
        this.elementToAdd = elementToAdd;
    }

    public void execute() {
        super.execute();
        this.addElement();
    }

    public void undo() {
        super.undo();
    }

    public void setSchemaProperties(SpecificationForExtensionsSchema appInfoSchemaSpec) {
        this.extensionSchemaSpec = appInfoSchemaSpec;
    }

    private void addElement() {
        if (this.input != null) {
            Document doc = this.input.getOwnerDocument();
            String name = this.elementToAdd.getAttribute("name");
            try {
                Element rootElement = doc.createElementNS(this.extensionSchemaSpec.getNamespaceURI(), name);
                String prefix = this.input.getPrefix();
                rootElement.setPrefix(prefix);
                String xmlns = prefix == null || prefix.equals("") ? "xmlns" : "xmlns:" + prefix;
                Attr nsURIAttribute = doc.createAttribute(xmlns);
                nsURIAttribute.setValue(this.extensionSchemaSpec.getNamespaceURI());
                rootElement.setAttributeNode(nsURIAttribute);
                this.input.appendChild(rootElement);
            }
            catch (Exception exception) {}
        }
    }
}

