/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesMainElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesUserDefUDDIRegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.model.v10.registry.Name;
import org.eclipse.wst.ws.internal.model.v10.registry.Registry;
import org.eclipse.wst.ws.internal.model.v10.taxonomy.Taxonomy;
import org.eclipse.wst.ws.internal.model.v10.uddiregistry.UDDIRegistry;
import org.eclipse.wst.ws.internal.registry.IRegistryManager;
import org.eclipse.wst.ws.internal.registry.RegistryService;
import org.eclipse.wst.ws.internal.registry.UDDIRegistryService;

public class FavoritesUserDefUDDIRegistryFolderElement
extends FavoritesFolderElement {
    public FavoritesUserDefUDDIRegistryFolderElement(String name, Model model, NodeManager nodeManager) {
        super(name, model, nodeManager);
    }

    public void init(FavoritesMainElement favMainElement) {
        RegistryService regService = RegistryService.instance();
        IRegistryManager regManager = regService.getDefaultRegistryManager();
        try {
            String[] regURIs = regManager.getRegistryURIs();
            int i = 0;
            while (i < regURIs.length) {
                Registry reg = regManager.loadRegistry(regURIs[i]);
                if (reg instanceof UDDIRegistry) {
                    UDDIRegistry uddiReg = (UDDIRegistry)reg;
                    EList names = uddiReg.getName();
                    String displayName = names != null && !names.isEmpty() ? ((Name)names.get(0)).getValue() : "";
                    FavoritesUserDefUDDIRegistryElement favUserDefUDDIRegElement = new FavoritesUserDefUDDIRegistryElement(displayName, this.getModel());
                    favUserDefUDDIRegElement.setNames((List)names);
                    favUserDefUDDIRegElement.setDescs((List)uddiReg.getDescription());
                    favUserDefUDDIRegElement.setVersion(uddiReg.getVersion());
                    favUserDefUDDIRegElement.setDefaultLogin(uddiReg.getDefaultLogin());
                    favUserDefUDDIRegElement.setDefaultPassword(uddiReg.getDefaultPassword());
                    favUserDefUDDIRegElement.setInquiryURL(uddiReg.getDiscoveryURL());
                    favUserDefUDDIRegElement.setPublishURL(uddiReg.getPublicationURL());
                    favUserDefUDDIRegElement.setSecureInquiryURL(uddiReg.getSecuredDiscoveryURL());
                    favUserDefUDDIRegElement.setSecurePublishURL(uddiReg.getSecuredPublicationURL());
                    Taxonomy[] taxonomies = regManager.loadTaxonomies(UDDIRegistryService.instance().getTaxonomyURIs(uddiReg));
                    favUserDefUDDIRegElement.setTaxonomies(taxonomies);
                    this.connect((Element)favUserDefUDDIRegElement, "relUserDefUDDIRegistryNode", "owner");
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    public boolean addFavorite(Hashtable table) {
        return true;
    }

    public boolean favoriteExists(Hashtable table) {
        return true;
    }

    public boolean removeFavoriteByNodeID(int nodeID, String pluginMetadataDirectory) {
        return true;
    }

    public boolean removeAllFavorites(String pluginMetadataDirectory) {
        return true;
    }

    public Enumeration getAllFavorites() {
        return this.getElements("relUserDefUDDIRegistryNode");
    }
}

