/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.edit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentList;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentSearchListProvider;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.internal.impl.ImportImpl;

public abstract class WSDLBaseSearchListProvider
implements IComponentSearchListProvider {
    protected void createWSDLComponentObjects(IComponentList list, List inputComponents, QualifiedName metaName) {
        Iterator it = inputComponents.iterator();
        while (it.hasNext()) {
            WSDLElement wsdlElement = (WSDLElement)it.next();
            String name = wsdlElement.getElement().getAttribute("name");
            String qualifier = wsdlElement.getEnclosingDefinition().getTargetNamespace();
            ComponentSpecification componentSpec = new ComponentSpecification();
            componentSpec.setMetaName(metaName);
            componentSpec.setName(name);
            componentSpec.setQualifier(qualifier);
            String location = wsdlElement.getEnclosingDefinition().getLocation();
            String platformResource = "platform:/resource";
            if (location != null && location.startsWith(platformResource)) {
                Path path = new Path(location.substring(platformResource.length()));
                IFile result = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                if (result != null) {
                    componentSpec.setFile(result);
                }
            }
            list.add((Object)componentSpec);
        }
    }

    protected List getWSDLFileImports(List wsdlImports) {
        ArrayList<ImportImpl> list = new ArrayList<ImportImpl>();
        Iterator it = wsdlImports.iterator();
        while (it.hasNext()) {
            ImportImpl importItem = (ImportImpl)it.next();
            importItem.importDefinitionOrSchema();
            if (importItem.getESchema() != null) continue;
            list.add(importItem);
        }
        return list;
    }
}

