/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.commands;

import java.util.List;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11TopLevelElementCommand;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceInfoManager;
import org.w3c.dom.Element;

public class W11EditNamespacesCommand
extends W11TopLevelElementCommand {
    private List namespacesInfoList;
    private String targetNamespace;
    private String targetNamespacePrefix;

    public W11EditNamespacesCommand(Definition definition) {
        super(Messages.getString("_UI_EDIT_NAMESPACES"), definition);
    }

    public void setNamespacesInfo(List namespaces) {
        this.namespacesInfoList = namespaces;
    }

    public void setTargetNamespace(String tns) {
        this.targetNamespace = tns;
    }

    public void setTargetNamespacePrefix(String prefix) {
        this.targetNamespacePrefix = prefix;
    }

    public void execute() {
        super.execute();
        if (this.targetNamespacePrefix != null) {
            Element element = this.definition.getElement();
            String oldPrefix = this.definition.getPrefix(this.definition.getTargetNamespace());
            element.removeAttribute("xmlns:" + oldPrefix);
            element.setAttribute("xmlns:" + this.targetNamespacePrefix, this.definition.getTargetNamespace());
        }
        if (this.targetNamespace != null) {
            String newValue = this.targetNamespace;
            String prefix = this.definition.getPrefix(this.definition.getTargetNamespace());
            this.definition.setTargetNamespace(newValue);
            this.definition.getElement().setAttribute("xmlns:" + prefix, newValue);
        }
        if (this.namespacesInfoList != null) {
            DOMNamespaceInfoManager namespaceInfoManager = new DOMNamespaceInfoManager();
            namespaceInfoManager.removeNamespaceInfo(this.definition.getElement());
            namespaceInfoManager.addNamespaceInfo(this.definition.getElement(), this.namespacesInfoList, false);
        }
    }
}

