/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.extensions.internal;

import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ServerExtensionsPlugin
extends AbstractUIPlugin {
    private static ServerExtensionsPlugin plugin;
    private ResourceBundle resourceBundle;
    protected static final String PROPERTIES = "org/eclipse/wst/rdb/server/extensions/internal/nls/ServerExtensionsMessages";
    protected static ResourceBundle properties;

    static {
        properties = null;
    }

    public ServerExtensionsPlugin() {
        plugin = this;
    }

    public static ServerExtensionsPlugin getDefault() {
        return plugin;
    }

    public static String getString(String key, Object[] substitutions) {
        String str = ServerExtensionsPlugin.getResourceBundle().getString(key);
        if (substitutions != null) {
            str = MessageFormat.format(str, substitutions);
        }
        return str;
    }

    public static ResourceBundle getResourceBundle() {
        if (properties == null) {
            try {
                properties = ResourceBundle.getBundle(PROPERTIES);
            }
            catch (MissingResourceException exception) {
                plugin.writeLog(4, 0, "ServerExtensionsPlugin:getResourceBundle.", exception);
            }
        }
        return properties;
    }

    public static String getString(String key) {
        try {
            return ServerExtensionsPlugin.getResourceBundle().getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static URL getInstallURL() {
        return ServerExtensionsPlugin.getDefault().getBundle().getEntry("/");
    }

    public ImageDescriptor getImageDescriptor(String key) {
        try {
            return ImageDescriptor.createFromURL((URL)new URL(ServerExtensionsPlugin.getInstallURL(), "icons" + File.separator + key + ".gif"));
        }
        catch (Exception e) {
            this.writeLog(4, 0, e.getMessage(), e);
            return null;
        }
    }

    public void writeLog(int severity, int code, String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        this.getLog().log((IStatus)new Status(severity, ServerExtensionsPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public static String getUniqueIdentifier() {
        return ServerExtensionsPlugin.getDefault().getBundle().getSymbolicName();
    }
}

