/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.document;

import java.util.HashMap;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public class HTMLDocumentTypeAdapterFactory
implements INodeAdapterFactory,
Preferences.IPropertyChangeListener {
    private int tagNameCase = 2;
    private int attrNameCase = 2;
    private Preferences preferences = null;
    private HashMap fDoc2AdapterMap = new HashMap();
    static /* synthetic */ Class class$0;

    public HTMLDocumentTypeAdapterFactory() {
        this.preferences = HTMLCorePlugin.getDefault().getPluginPreferences();
        if (this.preferences != null) {
            this.updateCases();
            this.preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        }
    }

    public INodeAdapter adapt(INodeNotifier notifier) {
        Object result = null;
        if (notifier instanceof IDOMDocument) {
            DocumentTypeAdapter oldAdapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((oldAdapter = (DocumentTypeAdapter)notifier.getExistingAdapter((Object)clazz)) != null) {
                result = oldAdapter;
            } else {
                result = new HTMLDocumentTypeAdapter((IDOMDocument)notifier, this);
                notifier.addAdapter((INodeAdapter)result);
                this.fDoc2AdapterMap.put(notifier, result);
            }
        }
        return result;
    }

    public int getAttrNameCase() {
        return this.attrNameCase;
    }

    public int getTagNameCase() {
        return this.tagNameCase;
    }

    public boolean isFactoryForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type == clazz;
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (event == null) {
            return;
        }
        String property = event.getProperty();
        if (property == null) {
            return;
        }
        if (property.equals("tagNameCase") || property.equals("attrNameCase")) {
            this.updateCases();
        }
    }

    private void updateCases() {
        this.tagNameCase = 2;
        this.attrNameCase = 2;
        if (this.preferences == null) {
            return;
        }
        int tagCase = this.preferences.getInt("tagNameCase");
        if (tagCase == 1) {
            this.tagNameCase = 2;
        } else if (tagCase == 2) {
            this.tagNameCase = 1;
        }
        int attCase = this.preferences.getInt("attrNameCase");
        if (attCase == 1) {
            this.attrNameCase = 2;
        } else if (attCase == 2) {
            this.tagNameCase = 1;
        }
    }

    public void release() {
        if (!this.fDoc2AdapterMap.isEmpty()) {
            Object[] docs = this.fDoc2AdapterMap.keySet().toArray();
            DocumentTypeAdapter adapter = null;
            int i = 0;
            while (i < docs.length) {
                adapter = (DocumentTypeAdapter)this.fDoc2AdapterMap.get(docs[i]);
                adapter.release();
                ((IDOMDocument)docs[i]).removeAdapter((INodeAdapter)adapter);
                ++i;
            }
            this.fDoc2AdapterMap.clear();
        }
        if (this.preferences != null) {
            this.preferences.removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        }
    }

    public INodeAdapterFactory copy() {
        return new HTMLDocumentTypeAdapterFactory();
    }
}

