/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.wsdl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLElementList;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLReaderImpl;
import org.eclipse.wst.wsi.internal.core.wsdl.xsd.InlineSchemaValidator;
import org.eclipse.wst.wsi.internal.core.xml.XMLTags;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;

public class WSDLDocument {
    protected String fileName = null;
    protected Definition definitions = null;
    protected WSDLElementList wsdlElementList = null;
    private Map schemas = new HashMap();
    private List schemasValidationErrors = new ArrayList();
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WSDLDocument(String fileName) throws WSDLException {
        this.fileName = fileName;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread thread = Thread.currentThread();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.wst.wsi.internal.core.wsdl.WSDLDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                thread.setContextClassLoader(clazz.getClassLoader());
                WSDLReaderImpl wsdlReader = new WSDLReaderImpl();
                wsdlReader.setFeature("javax.wsdl.verbose", false);
                wsdlReader.setFeature("javax.wsdl.importDocuments", true);
                Document document = XMLUtils.parseXMLDocument(fileName);
                this.definitions = wsdlReader.readWSDL(fileName, document);
                this.validateSchemas();
                this.wsdlElementList = wsdlReader.getElementList();
            }
            catch (Exception exception) {
                this.wsdlElementList = null;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            throw throwable;
        }
        {
            Object var5_7 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            return;
        }
    }

    public WSDLDocument(String fileName, Definition definitions) {
        this.fileName = fileName;
        this.definitions = definitions;
        this.schemas.clear();
        this.schemasValidationErrors.clear();
    }

    public String getLocation() {
        return this.fileName;
    }

    public Definition getDefinitions() {
        return this.definitions;
    }

    public PortType[] getPortTypes() {
        return this.definitions.getPortTypes().values().toArray(new PortType[0]);
    }

    public Binding[] getBindings() {
        return this.definitions.getBindings().values().toArray(new Binding[0]);
    }

    public Service[] getServices() {
        return this.definitions.getServices().values().toArray(new Service[0]);
    }

    public String toString() {
        return this.definitions == null ? "WSDL definition element not found." : this.definitions.toString();
    }

    public WSDLElementList getElementList() {
        return this.wsdlElementList;
    }

    public Map getSchemas() {
        return this.schemas;
    }

    public List getSchemasValidationErrors() {
        return this.schemasValidationErrors;
    }

    private void validateSchemas() {
        this.schemas.clear();
        this.schemasValidationErrors.clear();
        if (this.definitions != null && this.definitions.getTypes() != null && this.definitions.getTypes().getExtensibilityElements() != null) {
            InlineSchemaValidator schemaValidator = new InlineSchemaValidator();
            ArrayList<Object> parents = new ArrayList<Object>(2);
            parents.add(this.definitions.getTypes());
            parents.add(this.definitions);
            Iterator i = this.definitions.getTypes().getExtensibilityElements().iterator();
            while (i.hasNext()) {
                ExtensibilityElement extEl = (ExtensibilityElement)i.next();
                if (!extEl.getElementType().equals(XMLTags.ELEM_XSD_SCHEMA)) continue;
                Map map = null;
                try {
                    map = schemaValidator.validate(extEl, parents, this.fileName);
                }
                catch (Exception e) {
                    this.schemasValidationErrors.add(e.getMessage());
                }
                if (map == null) continue;
                this.schemas.putAll(map);
            }
        }
    }

    public static void main(String[] args) {
        try {
            WSDLDocument wsdlDocument = new WSDLDocument(args[0]);
            System.out.println(wsdlDocument.toString());
        }
        catch (Exception e) {
            e.toString();
            e.printStackTrace();
        }
        System.exit(0);
    }
}

