/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BP2102
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;
    private boolean importFound = false;

    public BP2102(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        try {
            Types t = (Types)entryContext.getEntry().getEntryDetail();
            List exts = t.getExtensibilityElements();
            Definition definition = null;
            definition = this.validator.analyzerContext.getCandidateInfo().getDefinition(t);
            if (definition == null) {
                throw new WSIException("Could not find types definition in any WSDL document.");
            }
            if (exts != null) {
                Iterator it = exts.iterator();
                while (it.hasNext()) {
                    ExtensibilityElement el = (ExtensibilityElement)it.next();
                    if (el instanceof UnknownExtensibilityElement && el.getElementType().equals(ELEM_XSD_SCHEMA)) {
                        this.testNode(((UnknownExtensibilityElement)el).getElement(), definition.getDocumentBaseURI());
                    }
                    if (!this.result.equals("failed")) continue;
                    this.failureDetail = this.validator.createFailureDetail(this.failureDetailMessage, entryContext);
                }
            }
            if (!this.importFound) {
                this.result = "notApplicable";
            }
        }
        catch (Throwable throwable) {
            this.result = "notApplicable";
            this.failureDetail = this.validator.createFailureDetail("WSDL document can not be processed", entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private void testNode(Node n, String context) {
        while (n != null) {
            if (1 == n.getNodeType()) {
                block9: {
                    if (XMLUtils.equals(n, ELEM_XSD_IMPORT)) {
                        this.importFound = true;
                        Element im = (Element)n;
                        Attr schemaLocation = XMLUtils.getAttribute(im, ATTR_XSD_SCHEMALOCATION);
                        Attr namespace = XMLUtils.getAttribute(im, ATTR_XSD_NAMESPACE);
                        if (schemaLocation == null && namespace != null) {
                            Map schemasMap = this.validator.wsdlDocument.getSchemas();
                            if (schemasMap.keySet().contains(namespace.getValue())) {
                                n = n.getNextSibling();
                                continue;
                            }
                            schemaLocation = namespace;
                        }
                        if (schemaLocation != null && schemaLocation.getValue() != null) {
                            try {
                                Document schema = this.validator.parseXMLDocumentURL(schemaLocation.getValue(), context);
                                if (XMLUtils.equals(schema.getDocumentElement(), ELEM_XSD_SCHEMA)) {
                                    this.testNode(schema.getDocumentElement().getFirstChild(), XMLUtils.createURLString(schemaLocation.getValue(), context));
                                    break block9;
                                }
                                throw new Exception();
                            }
                            catch (Throwable throwable) {
                                this.result = "failed";
                                this.failureDetailMessage = schemaLocation.getValue();
                                break;
                            }
                        }
                        this.result = "notApplicable";
                        this.failureDetailMessage = "schemaLocation == null and namespace == null";
                        break;
                    }
                }
                this.testNode(n.getFirstChild(), context);
            }
            n = n.getNextSibling();
        }
    }
}

