/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.symbols;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.AbstractSymbolSourceProviderFactory;
import org.eclipse.jst.jsf.context.symbol.source.ISymbolSourceProvider;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTExternalContext;
import org.eclipse.jst.jsf.designtime.symbols.FileContextUtil;
import org.eclipse.jst.jsf.designtime.symbols.SymbolUtil;

public class DefaultBuiltInSymbolProvider
extends AbstractSymbolSourceProviderFactory
implements ISymbolSourceProvider {
    private static final String APPLICATION_SCOPE = "applicationScope";
    private static final String SESSION_SCOPE = "sessionScope";
    private static final String REQUEST_SCOPE = "requestScope";
    private static final String COOKIE_IMPLICIT_OBJ = "cookie";
    private static final String FACES_CONTEXT_IMPLICIT_OBJ = "facesContext";
    private static final String HEADER_IMPLICIT_OBJ = "header";
    private static final String HEADER_VALUES_IMPLICIT_OBJ = "headerValues";
    private static final String INIT_PARAM_IMPLICIT_OBJ = "initParam";
    private static final String PARAM_IMPLICIT_OBJ = "param";
    private static final String PARAM_VALUES_IMPLICIT_OBJ = "paramValues";
    private static final String VIEW_IMPLICIT_OBJ = "view";

    protected ISymbolSourceProvider create(IProject project) {
        return this;
    }

    public ISymbol[] getSymbols(IAdaptable context, int symbolScopeMask) {
        IFile fileContext = FileContextUtil.deriveIFileFromContext(context);
        return this.getSymbolsForScope(fileContext, symbolScopeMask).toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
    }

    public ISymbol[] getSymbols(String prefix, IAdaptable context, int symbolScopeMask) {
        return SymbolUtil.filterSymbolsByPrefix(this.getSymbols(context, symbolScopeMask), prefix);
    }

    private List getSymbolsForScope(IFile file, int symbolScopeMask) {
        ArrayList symbols = new ArrayList();
        if ((symbolScopeMask & 1) != 0) {
            symbols.addAll(this.getRequestScopeSymbols(file));
        }
        if ((symbolScopeMask & 2) != 0) {
            symbols.addAll(this.getSessionScopeSymbols(file));
        }
        if ((symbolScopeMask & 4) != 0) {
            symbols.addAll(this.getApplicationScopeSymbols(file));
        }
        return symbols;
    }

    private List getRequestScopeSymbols(IFile file) {
        ArrayList<ISymbol> symbols = new ArrayList<ISymbol>();
        symbols.add(this.createScopeSymbol(file, 1, REQUEST_SCOPE));
        symbols.add(this.createUnresolvedMapSymbol(COOKIE_IMPLICIT_OBJ));
        symbols.add(this.createUnresolvedMapSymbol(HEADER_IMPLICIT_OBJ));
        symbols.add(this.createUnresolvedMapSymbol(HEADER_VALUES_IMPLICIT_OBJ));
        symbols.add(this.createUnresolvedMapSymbol(PARAM_IMPLICIT_OBJ));
        symbols.add(this.createUnresolvedMapSymbol(PARAM_VALUES_IMPLICIT_OBJ));
        symbols.add(this.createUnresolvedMapSymbol(FACES_CONTEXT_IMPLICIT_OBJ));
        symbols.add(this.createUnresolvedMapSymbol(VIEW_IMPLICIT_OBJ));
        return symbols;
    }

    private List getSessionScopeSymbols(IFile file) {
        return Collections.singletonList(this.createScopeSymbol(file, 2, SESSION_SCOPE));
    }

    private List getApplicationScopeSymbols(IFile file) {
        ArrayList<ISymbol> symbols = new ArrayList<ISymbol>();
        symbols.add(this.createUnresolvedMapSymbol(INIT_PARAM_IMPLICIT_OBJ));
        symbols.add(this.createScopeSymbol(file, 4, APPLICATION_SCOPE));
        return symbols;
    }

    private DTExternalContext getExternalContext(IFile file) {
        IProject project = this.getProject();
        DesignTimeApplicationManager appMgr = DesignTimeApplicationManager.getInstance(project);
        return appMgr.getFacesContext(file).getDTExternalContext((IAdaptable)file);
    }

    private ISymbol createScopeSymbol(IFile file, int scopeMask, String name) {
        DTExternalContext externalContext = this.getExternalContext(file);
        ScopeMap mapSource = new ScopeMap(externalContext, scopeMask);
        IMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIMapTypeDescriptor();
        typeDesc.setMapSource((Map)mapSource);
        typeDesc.setTypeSignature("Ljava.util.Map;");
        IInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIInstanceSymbol();
        symbol.setName(name);
        symbol.setRuntimeSource(ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        return symbol;
    }

    private ISymbol createUnresolvedMapSymbol(String name) {
        IMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIMapTypeDescriptor();
        typeDesc.setMapSource(Collections.EMPTY_MAP);
        typeDesc.setTypeSignature("Ljava.util.Map;");
        IInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIInstanceSymbol();
        symbol.setName(name);
        symbol.setRuntimeSource(ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        return symbol;
    }

    public boolean isProvider(IAdaptable context) {
        IFile file = FileContextUtil.deriveIFileFromContext(context);
        return file != null && file.getProject() == this.getProject();
    }

    private static class ScopeMap
    extends AbstractMap {
        private final DTExternalContext _externalContext;
        private final int _scopeMask;

        ScopeMap(DTExternalContext externalContext, int scopeMask) {
            this._externalContext = externalContext;
            this._scopeMask = scopeMask;
        }

        public Set entrySet() {
            Map scopeMap = this._externalContext.getMapForScope(this._scopeMask);
            return scopeMap.entrySet();
        }
    }
}

