/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.project.facet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryDecorator;
import org.eclipse.jst.jsf.core.internal.project.facet.IJSFFacetInstallDataModelProperties;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.jst.jsf.ui.internal.Messages;
import org.eclipse.jst.jsf.ui.internal.jsflibraryconfig.IJSFImplLibraryCreationListener;
import org.eclipse.jst.jsf.ui.internal.jsflibraryconfig.JSFImplLibraryCreationEvent;
import org.eclipse.jst.jsf.ui.internal.jsflibraryconfig.JSFLibraryConfigControl;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.IWizardContext;

public class JSFFacetInstallPage
extends DataModelWizardPage
implements IJSFFacetInstallDataModelProperties,
IFacetWizardPage {
    private Label lblJSFImpl;
    private Label lblJSFConfig;
    private Text txtJSFConfig;
    private Label lblJSFServletName;
    private Text txtJSFServletName;
    private Label lblJSFServletURLPatterns;
    private org.eclipse.swt.widgets.List lstJSFServletURLPatterns;
    private Button btnAddPattern;
    private Button btnRemovePattern;
    private IDialogSettings dialogSettings;
    private IDataModel webAppDataModel;
    private static final String SETTINGS_ROOT = "org.eclipse.jst.jsf.ui.internal.JSFUiPlugin.jsfFacetInstall";
    private static final String SETTINGS_CONFIG = "configPath";
    private static final String SETTINGS_SERVLET = "servletName";
    private static final String SETTINGS_URL_MAPPINGS = "urlMappings";
    private static final String SETTINGS_URL_PATTERN = "pattern";
    private static final String SETTINGS_DEPLOY_IMPL = "deployImplementation";
    private JSFLibraryConfigControl jsfLibCfgComp = null;
    private String projectName = null;
    private Composite composite = null;

    public JSFFacetInstallPage() {
        super(DataModelFactory.createDataModel((IDataModelProvider)new AbstractDataModelProvider(){}), "jsf.facet.install.page");
        this.setTitle(Messages.JSFFacetInstallPage_title);
        this.setDescription(Messages.JSFFacetInstallPage_description);
        this.dialogSettings = JSFUiPlugin.getDefault().getDialogSettings();
    }

    protected Composite createTopLevelComposite(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.composite = new Composite(parent, 0);
        GridLayout jsfCompositeLayout = new GridLayout(3, false);
        jsfCompositeLayout.marginLeft = 0;
        this.composite.setLayout((Layout)jsfCompositeLayout);
        this.lblJSFImpl = new Label(this.composite, 0);
        this.lblJSFImpl.setLayoutData((Object)new GridData(1, 1, false, false));
        this.lblJSFImpl.setText(Messages.JSFFacetInstallPage_JSFLibraryLabel0);
        ((GridLayout)this.composite.getLayout()).marginLeft = 0;
        IProject project = this.getProjectHandle();
        this.jsfLibCfgComp = new JSFLibraryConfigControl(this.composite, 0, project);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.jsfLibCfgComp, 31);
        this.jsfLibCfgComp.addOkClickedListener(new IJSFImplLibraryCreationListener(){

            public void okClicked(JSFImplLibraryCreationEvent event) {
                if (event.isLibraryCreated()) {
                    JSFFacetInstallPage.this.validatePage();
                }
            }
        });
        GridData gd_comp = new GridData(4, 4, true, true);
        gd_comp.horizontalSpan = 2;
        ((GridLayout)this.jsfLibCfgComp.getLayout()).marginLeft = 0;
        this.jsfLibCfgComp.setLayoutData(gd_comp);
        this.lblJSFConfig = new Label(this.composite, 0);
        this.lblJSFConfig.setText(Messages.JSFFacetInstallPage_JSFConfigLabel);
        this.lblJSFConfig.setLayoutData((Object)new GridData(1));
        this.txtJSFConfig = new Text(this.composite, 2048);
        GridData gd1 = new GridData(768);
        gd1.horizontalSpan = 2;
        this.txtJSFConfig.setLayoutData((Object)gd1);
        this.lblJSFServletName = new Label(this.composite, 0);
        this.lblJSFServletName.setText(Messages.JSFFacetInstallPage_JSFServletNameLabel);
        this.lblJSFServletName.setLayoutData((Object)new GridData(1));
        this.txtJSFServletName = new Text(this.composite, 2048);
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = 2;
        this.txtJSFServletName.setLayoutData((Object)gd2);
        this.lblJSFServletURLPatterns = new Label(this.composite, 0);
        this.lblJSFServletURLPatterns.setText(Messages.JSFFacetInstallPage_JSFURLMappingLabel);
        this.lblJSFServletURLPatterns.setLayoutData((Object)new GridData(3));
        this.lstJSFServletURLPatterns = new org.eclipse.swt.widgets.List(this.composite, 2048);
        GridData gd3 = new GridData(768);
        gd3.heightHint = this.convertHeightInCharsToPixels(5);
        this.lstJSFServletURLPatterns.setLayoutData((Object)gd3);
        this.lstJSFServletURLPatterns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFFacetInstallPage.this.btnRemovePattern.setEnabled(JSFFacetInstallPage.this.lstJSFServletURLPatterns.getSelectionCount() > 0);
            }
        });
        Composite btnComposite = new Composite(this.composite, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginLeft = 0;
        btnComposite.setLayout((Layout)gl);
        btnComposite.setLayoutData((Object)new GridData(19));
        this.btnAddPattern = new Button(btnComposite, 0);
        this.btnAddPattern.setText(Messages.JSFFacetInstallPage_Add2);
        this.btnAddPattern.setLayoutData((Object)new GridData(770));
        this.btnAddPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(JSFFacetInstallPage.this.getShell(), Messages.JSFFacetInstallPage_PatternDialogTitle, Messages.JSFFacetInstallPage_PatternDialogDesc, null, new IInputValidator(this){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public String isValid(String newText) {
                        return JSFFacetInstallPage.access$3(4.access$0(this.this$1), newText);
                    }
                });
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    JSFFacetInstallPage.this.addItemToList(dialog.getValue(), true);
                }
            }

            static /* synthetic */ JSFFacetInstallPage access$0(4 var0) {
                return var0.JSFFacetInstallPage.this;
            }
        });
        this.btnRemovePattern = new Button(btnComposite, 0);
        this.btnRemovePattern.setText(Messages.JSFFacetInstallPage_Remove);
        this.btnRemovePattern.setLayoutData((Object)new GridData(770));
        this.btnRemovePattern.setEnabled(false);
        this.btnRemovePattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFFacetInstallPage.this.removeItemFromList(JSFFacetInstallPage.this.lstJSFServletURLPatterns.getSelection());
                JSFFacetInstallPage.this.btnRemovePattern.setEnabled(false);
            }
        });
        this.addModificationListeners();
        this.getContainer().getShell().pack();
        return this.composite;
    }

    private void initializeValues() {
        IDialogSettings root = this.dialogSettings.getSection(SETTINGS_ROOT);
        String conf = null;
        if (root != null) {
            conf = root.get(SETTINGS_CONFIG);
        }
        if (conf == null || conf.equals("")) {
            conf = (String)this.model.getDefaultProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH");
        }
        this.txtJSFConfig.setText(conf);
        String servletName = null;
        if (root != null) {
            servletName = root.get(SETTINGS_SERVLET);
        }
        if (servletName == null || servletName.equals("")) {
            servletName = (String)this.model.getDefaultProperty("IJSFFacetInstallDataModelProperties.SERVLET_NAME");
        }
        this.txtJSFServletName.setText(servletName);
        this.loadURLMappingPatterns(root);
    }

    private void saveSettings() {
        DialogSettings root = new DialogSettings(SETTINGS_ROOT);
        this.dialogSettings.addSection((IDialogSettings)root);
        root.put(SETTINGS_DEPLOY_IMPL, String.valueOf(this.getDeployJSFImpl()));
        root.put(SETTINGS_CONFIG, this.getJSFConfig());
        root.put(SETTINGS_SERVLET, this.getJSFServletName());
        DialogSettings mappings = new DialogSettings(SETTINGS_URL_MAPPINGS);
        root.addSection((IDialogSettings)mappings);
        mappings.put(SETTINGS_URL_PATTERN, this.getJSFPatterns());
    }

    private boolean getDeployJSFImpl() {
        if (this.jsfLibCfgComp.getSelectedJSFLibImplementation() == null) {
            return false;
        }
        return this.jsfLibCfgComp.getSelectedJSFLibImplementation().checkForDeploy();
    }

    private String getJSFConfig() {
        return this.txtJSFConfig.getText().trim();
    }

    private String getJSFServletName() {
        return this.txtJSFServletName.getText().trim();
    }

    private String[] getJSFPatterns() {
        return this.lstJSFServletURLPatterns.getItems();
    }

    public void setConfig(Object config) {
        this.model.removeListener((IDataModelListener)this);
        this.synchHelper.dispose();
        this.model = (IDataModel)config;
        this.model.addListener((IDataModelListener)this);
        this.synchHelper = this.initializeSynchHelper(this.model);
    }

    public void transferStateToConfig() {
        this.saveSettings();
        ArrayList<JSFLibraryDecorator> implLibs = new ArrayList<JSFLibraryDecorator>();
        implLibs.add(this.jsfLibCfgComp.getSelectedJSFLibImplementation());
        List compLibs = this.jsfLibCfgComp.getSelectedJSFLibComponents();
        this.model.setProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION_LIBRARIES", implLibs);
        this.model.setProperty("IJSFFacetInstallDataModelProperties.COMPONENT_LIBRARIES", (Object)compLibs);
    }

    private void addModificationListeners() {
        this.synchHelper.synchText(this.txtJSFConfig, "IJSFFacetInstallDataModelProperties.CONFIG_PATH", null);
        this.synchHelper.synchText(this.txtJSFServletName, "IJSFFacetInstallDataModelProperties.SERVLET_NAME", null);
    }

    private String isValidPattern(String value) {
        if (value == null || value.trim().equals("")) {
            return Messages.JSFFacetInstallPage_PatternEmptyMsg;
        }
        if (this.lstJSFServletURLPatterns.indexOf(value) >= 0) {
            return Messages.JSFFacetInstallPage_PatternSpecifiedMsg;
        }
        return null;
    }

    private void loadURLMappingPatterns(IDialogSettings root) {
        this.lstJSFServletURLPatterns.removeAll();
        IDialogSettings mappings = null;
        if (root != null) {
            mappings = root.getSection(SETTINGS_URL_MAPPINGS);
        }
        String[] patterns = null;
        if (mappings != null) {
            patterns = mappings.getArray(SETTINGS_URL_PATTERN);
        }
        if (patterns == null || patterns.length == 0) {
            patterns = (String[])this.model.getDefaultProperty("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS");
        }
        int i = 0;
        while (i < patterns.length) {
            this.addItemToList(patterns[i], false);
            ++i;
        }
    }

    private void addItemToList(String pattern, boolean selectMe) {
        this.lstJSFServletURLPatterns.add(pattern == null ? "" : pattern);
        if (pattern == null && selectMe) {
            this.lstJSFServletURLPatterns.setSelection(this.lstJSFServletURLPatterns.getItemCount() - 1);
        }
        this.updateModelForURLPattern();
    }

    private void removeItemFromList(String[] selection) {
        int i = 0;
        while (i < selection.length) {
            String sel = selection[i];
            this.lstJSFServletURLPatterns.remove(sel);
            ++i;
        }
        this.updateModelForURLPattern();
    }

    private void updateModelForURLPattern() {
        this.model.setProperty("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS", (Object)this.lstJSFServletURLPatterns.getItems());
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IJSFFacetInstallDataModelProperties.IMPLEMENTATION", "IJSFFacetInstallDataModelProperties.DEPLOY_IMPLEMENTATION", "IJSFFacetInstallDataModelProperties.CONFIG_PATH", "IJSFFacetInstallDataModelProperties.SERVLET_NAME"};
    }

    public void setWizardContext(IWizardContext context) {
        this.projectName = context.getProjectName();
        Iterator it = context.getSelectedProjectFacets().iterator();
        IProjectFacetVersion webFacetVersion = null;
        while (it.hasNext()) {
            IProjectFacetVersion pfv = (IProjectFacetVersion)it.next();
            if (!pfv.getProjectFacet().getId().equals("jst.web")) continue;
            webFacetVersion = pfv;
            break;
        }
        if (webFacetVersion != null) {
            try {
                this.webAppDataModel = (IDataModel)context.getConfig(webFacetVersion, IFacetedProject.Action.Type.INSTALL, context.getProjectName());
                if (this.webAppDataModel != null) {
                    this.webAppDataModel.addListener((IDataModelListener)this);
                }
            }
            catch (CoreException e) {
                JSFUiPlugin.log(4, Messages.JSFFacetInstallPage_ErrorNoWebAppDataModel, e);
            }
        }
    }

    public void propertyChanged(DataModelEvent event) {
        String propertyName;
        if (this.webAppDataModel != null && (propertyName = event.getPropertyName()).equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
            this.model.setStringProperty("IJSFFacetInstallDataModelProperties.WEBCONTENT_DIR", event.getProperty().toString());
        }
        super.propertyChanged(event);
    }

    public void dispose() {
        if (this.webAppDataModel != null) {
            this.webAppDataModel.removeListener((IDataModelListener)this);
        }
        super.dispose();
    }

    protected void restoreDefaultSettings() {
        this.initializeValues();
    }

    private IProject getProjectHandle() {
        if (this.projectName != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        }
        return null;
    }

    static /* synthetic */ String access$3(JSFFacetInstallPage jSFFacetInstallPage, String string) {
        return jSFFacetInstallPage.isValidPattern(string);
    }
}

