/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.operators;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.core.internal.types.ValueType;
import org.eclipse.jst.jsf.validation.el.operators.AddArithmeticBinaryOperator;
import org.eclipse.jst.jsf.validation.el.operators.AndBinaryOperator;
import org.eclipse.jst.jsf.validation.el.operators.DivArithmeticBinaryOperator;
import org.eclipse.jst.jsf.validation.el.operators.EqualsBinaryRelationalOperator;
import org.eclipse.jst.jsf.validation.el.operators.GreaterThanEqRelationalBinaryOperator;
import org.eclipse.jst.jsf.validation.el.operators.GreaterThanRelationalBinaryOperator;
import org.eclipse.jst.jsf.validation.el.operators.LessThanEqRelationalBinaryOperator;
import org.eclipse.jst.jsf.validation.el.operators.LessThanRelationalBinaryOperator;
import org.eclipse.jst.jsf.validation.el.operators.ModArithmeticBinaryOperator;
import org.eclipse.jst.jsf.validation.el.operators.MultiplyArithmeticBinaryOperator;
import org.eclipse.jst.jsf.validation.el.operators.NotEqualsBinaryRelationalOperator;
import org.eclipse.jst.jsf.validation.el.operators.OrBinaryOperator;
import org.eclipse.jst.jsf.validation.el.operators.SubtractArithmeticBinaryOperator;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;

public abstract class BinaryOperator {
    public static BinaryOperator getBinaryOperator(Token operatorToken) {
        switch (operatorToken.kind) {
            case 41: 
            case 42: {
                return new AndBinaryOperator();
            }
            case 43: 
            case 44: {
                return new OrBinaryOperator();
            }
            case 18: 
            case 19: {
                return new EqualsBinaryRelationalOperator();
            }
            case 24: 
            case 25: {
                return new NotEqualsBinaryRelationalOperator();
            }
            case 14: 
            case 15: {
                return new GreaterThanRelationalBinaryOperator();
            }
            case 22: 
            case 23: {
                return new GreaterThanEqRelationalBinaryOperator();
            }
            case 16: 
            case 17: {
                return new LessThanRelationalBinaryOperator();
            }
            case 20: 
            case 21: {
                return new LessThanEqRelationalBinaryOperator();
            }
            case 32: {
                return new AddArithmeticBinaryOperator();
            }
            case 33: {
                return new SubtractArithmeticBinaryOperator();
            }
            case 34: {
                return new MultiplyArithmeticBinaryOperator();
            }
            case 35: 
            case 36: {
                return new DivArithmeticBinaryOperator();
            }
            case 37: 
            case 38: {
                return new ModArithmeticBinaryOperator();
            }
        }
        throw new IllegalArgumentException("Unknown binary operator: " + operatorToken.image);
    }

    BinaryOperator() {
    }

    public abstract ValueType performOperation(ValueType var1, ValueType var2);

    public abstract Diagnostic validate(ValueType var1, ValueType var2);
}

