/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.api.model.datatype;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BooleanPropertyAttributeType implements Enumerator
{
    READABLE(0, "readable", "READABLE"),
    WRITABLE(1, "writable", "WRITABLE"),
    EVENTABLE(2, "eventable", "EVENTABLE");

    public static final int READABLE_VALUE = 0;
    public static final int WRITABLE_VALUE = 1;
    public static final int EVENTABLE_VALUE = 2;
    private static final BooleanPropertyAttributeType[] VALUES_ARRAY;
    public static final List<BooleanPropertyAttributeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BooleanPropertyAttributeType[]{READABLE, WRITABLE, EVENTABLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BooleanPropertyAttributeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BooleanPropertyAttributeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BooleanPropertyAttributeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BooleanPropertyAttributeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BooleanPropertyAttributeType get(int value) {
        switch (value) {
            case 0: {
                return READABLE;
            }
            case 1: {
                return WRITABLE;
            }
            case 2: {
                return EVENTABLE;
            }
        }
        return null;
    }

    private BooleanPropertyAttributeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

