/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp.url;

import org.eclipse.virgo.snaps.core.internal.webapp.url.ImmutablePathTranslation;
import org.eclipse.virgo.snaps.core.internal.webapp.url.PathTranslation;
import org.eclipse.virgo.snaps.core.internal.webapp.url.UrlPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUrlPattern
implements UrlPattern {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_MAPPING = "/";

    public static boolean isDefaultPattern(String pattern) {
        return DEFAULT_MAPPING.equals(pattern);
    }

    @Override
    public boolean matches(String path) {
        boolean matches = path.startsWith(DEFAULT_MAPPING);
        if (matches) {
            this.logger.info("Path '{}' matches pattern '{}'", (Object)path, (Object)DEFAULT_MAPPING);
        } else {
            this.logger.info("Path '{}' does not match pattern '{}'", (Object)path, (Object)DEFAULT_MAPPING);
        }
        return matches;
    }

    @Override
    public PathTranslation translate(String servletPath) {
        String pathInfo = null;
        int index = servletPath.indexOf(DEFAULT_MAPPING, 1);
        if (index > -1) {
            pathInfo = servletPath.substring(index);
            servletPath = servletPath.substring(0, index);
        }
        this.logger.info("Translated path '{}' to '{}'", (Object)servletPath, (Object)pathInfo);
        return new ImmutablePathTranslation(servletPath, pathInfo);
    }
}

