/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp.container;

import java.io.IOException;
import javax.servlet.ServletException;
import org.eclipse.virgo.snaps.core.internal.webapp.SnapServletContext;

final class ManagerUtils {
    ManagerUtils() {
    }

    static Class<?> loadComponentClass(String className, ClassLoader fallbackClassLoader) throws ClassNotFoundException {
        try {
            return ManagerUtils.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return fallbackClassLoader.loadClass(className);
        }
    }

    static <T> T doWithThreadContextClassLoader(ClassLoader classLoader, ClassLoaderCallback<T> callback) throws ServletException, IOException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(classLoader);
            T t = callback.doWithClassLoader();
            return t;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    static String expandMapping(String urlPattern, SnapServletContext snapServletContext) {
        if ("/".equals(urlPattern) || urlPattern.startsWith("*.")) {
            return urlPattern;
        }
        return String.valueOf(snapServletContext.getSnapContextPath()) + urlPattern;
    }

    static interface ClassLoaderCallback<T> {
        public T doWithClassLoader() throws ServletException, IOException;
    }
}

