/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.snaps.core.OsgiSnapRegistry;
import org.eclipse.virgo.snaps.core.RequestRouter;
import org.eclipse.virgo.snaps.core.SnapRegistry;
import org.eclipse.virgo.snaps.core.internal.SnapsLogEvents;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapHostFilter
implements Filter {
    private static final String ATTRIBUTE_OSGI_CONTEXT = "osgi-bundlecontext";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EventLogger eventLogger;
    private volatile String contextPath;
    private volatile RequestRouter router;

    public SnapHostFilter() {
        EventLogger eventLogger;
        BundleContext bundleContext = FrameworkUtil.getBundle(SnapHostFilter.class).getBundleContext();
        this.eventLogger = eventLogger = (EventLogger)bundleContext.getService(bundleContext.getServiceReference(EventLogger.class.getName()));
    }

    SnapHostFilter(EventLogger eventLogger) {
        this.eventLogger = eventLogger;
    }

    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            this.router.service(httpRequest, httpResponse, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public final void init(FilterConfig filterConfig) throws ServletException {
        SnapRegistry registry = this.createSnapRegistry(filterConfig.getServletContext());
        registry.init();
        this.router = new RequestRouter(registry, filterConfig.getServletContext());
        this.contextPath = filterConfig.getServletContext().getContextPath();
        this.eventLogger.log((LogEvent)SnapsLogEvents.HOST_CREATED, new Object[]{this.contextPath});
    }

    public final void destroy() {
        if (this.router != null) {
            this.router.destroy();
            this.router = null;
        }
        this.eventLogger.log((LogEvent)SnapsLogEvents.HOST_DESTROYED, new Object[]{this.contextPath});
    }

    protected SnapRegistry createSnapRegistry(ServletContext servletContext) throws ServletException {
        try {
            return new OsgiSnapRegistry(this.getRequiredBundleContext(servletContext));
        }
        catch (InvalidSyntaxException e) {
            this.logger.error("Unable to create OsgiSnapRegistry", (Throwable)e);
            throw new ServletException("Unable to create OsgiSnapRegistry.", (Throwable)e);
        }
    }

    protected final BundleContext getRequiredBundleContext(ServletContext servletContext) throws ServletException {
        Object attr = servletContext.getAttribute(ATTRIBUTE_OSGI_CONTEXT);
        if (attr == null) {
            this.logger.error("ServletContext attribute '{}' is missing.", (Object)ATTRIBUTE_OSGI_CONTEXT);
            throw new ServletException("ServletContext attribute 'osgi-bundlecontext' is missing.");
        }
        return (BundleContext)attr;
    }
}

