/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.virgo.kernel.install.artifact.ScopeServiceRepository;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.deployer.api.core.FatalDeploymentException;
import org.osgi.framework.Version;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class SpringConfigServiceModelScanner {
    private static final String ATTRIBUTE_REF = "ref";
    private static final String ATTRIBUTE_INTERFACE = "interface";
    private static final String ELEMENT_VALUE = "value";
    private static final String ELEMENT_INTERFACES = "interfaces";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ELEMENT_ENTRY = "entry";
    private static final String ELEMENT_SERVICE_PROPERTIES = "service-properties";
    private static final String SPRING_DM_NAMESPACE = "http://www.springframework.org/schema/osgi";
    private static final String SPRING_BEANS_NAMESPACE = "http://www.springframework.org/schema/beans";
    private static final String ELEMENT_SERVICE = "service";
    private static final String BEAN_NAME_PROPERTY = "org.eclipse.gemini.blueprint.bean.name";
    private final EventLogger eventLogger;
    private final ScopeServiceRepository repository;
    private final DocumentBuilder documentBuilder;
    private final String scopeName;

    public SpringConfigServiceModelScanner(String scopeName, ScopeServiceRepository repository, EventLogger eventLogger) {
        this.scopeName = scopeName;
        this.repository = repository;
        this.eventLogger = eventLogger;
        this.documentBuilder = this.createDocumentBuilder();
    }

    public void scanConfigFile(String bundleSymbolicName, Version bundleVersion, String configFileName, InputStream stream) throws DeploymentException {
        Document doc = this.parseConfigFile(bundleSymbolicName, bundleVersion, configFileName, stream);
        this.doScopeServices(doc.getDocumentElement().getChildNodes());
    }

    private void doScopeServices(NodeList childNodes) {
        int x = 0;
        while (x < childNodes.getLength()) {
            Node node = childNodes.item(x);
            if (this.isServiceElement(node)) {
                this.parseServiceElement((Element)node);
            }
            this.doScopeServices(node.getChildNodes());
            ++x;
        }
    }

    private void parseServiceElement(Element elem) {
        String[] types = this.extractInterfaces(elem);
        Dictionary<String, Object> properties = this.extractServiceProperties(elem);
        this.repository.recordService(this.scopeName, types, properties);
    }

    private String[] extractInterfaces(Element e) {
        HashSet<String> exportedInterfaces = new HashSet<String>();
        String iface = StringUtils.trimWhitespace((String)e.getAttribute(ATTRIBUTE_INTERFACE));
        if (StringUtils.hasText((String)iface)) {
            exportedInterfaces.add(iface);
        } else {
            NodeList children = e.getChildNodes();
            int y = 0;
            while (y < children.getLength()) {
                Node child = children.item(y);
                if (child instanceof Element && this.isInterfacesElement(child)) {
                    Element elem = (Element)child;
                    NodeList intChildren = elem.getChildNodes();
                    int i = 0;
                    while (i < intChildren.getLength()) {
                        Node intChild = intChildren.item(i);
                        if (this.isValueElement(intChild)) {
                            exportedInterfaces.add(StringUtils.trimWhitespace((String)intChild.getTextContent()));
                        }
                        ++i;
                    }
                }
                ++y;
            }
        }
        return exportedInterfaces.toArray(new String[exportedInterfaces.size()]);
    }

    private Dictionary<String, Object> extractServiceProperties(Element elem) {
        NodeList servicePropertiesElems = elem.getElementsByTagNameNS(SPRING_DM_NAMESPACE, ELEMENT_SERVICE_PROPERTIES);
        Dictionary p = null;
        if (servicePropertiesElems.getLength() > 0) {
            p = new Hashtable<String, Object>();
            Node item = servicePropertiesElems.item(0);
            this.readServiceProperties((Element)item, p);
        }
        p = this.addStandardServiceProperties(elem, p);
        return p;
    }

    private Dictionary<String, Object> addStandardServiceProperties(Element elem, Dictionary<String, Object> p) {
        String beanName = StringUtils.trimWhitespace((String)elem.getAttribute(ATTRIBUTE_REF));
        if (StringUtils.hasText((String)beanName)) {
            if (p == null) {
                p = new Hashtable<String, Object>();
            }
            p.put(BEAN_NAME_PROPERTY, beanName);
        }
        return p;
    }

    private void readServiceProperties(Element servicePropertiesElement, Dictionary<String, Object> serviceProperties) {
        NodeList childNodes = servicePropertiesElement.getChildNodes();
        int y = 0;
        while (y < childNodes.getLength()) {
            Node child = childNodes.item(y);
            if (this.isEntryElement(child)) {
                Element entry = (Element)child;
                serviceProperties.put(entry.getAttribute(ATTRIBUTE_KEY), entry.getAttribute("value"));
            }
            ++y;
        }
    }

    private Document parseConfigFile(String bundleSymbolicName, Version bundleVersion, String configFileName, InputStream stream) throws DeploymentException {
        try {
            return this.documentBuilder.parse(new InputSource(stream));
        }
        catch (SAXException ex) {
            this.eventLogger.log((LogEvent)DeployerLogEvents.CONFIG_FILE_ERROR, (Throwable)ex, new Object[]{configFileName, bundleSymbolicName, bundleVersion});
            throw new DeploymentException("Error parsing configuration file '" + configFileName + "'.", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new FatalDeploymentException("Error accessing configuration file '" + configFileName + "'.", (Throwable)ex);
        }
    }

    private DocumentBuilder createDocumentBuilder() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new FatalDeploymentException("Unable to create DocumentBuilder - JAXP parser configuration error.", (Throwable)e);
        }
    }

    private boolean isValueElement(Node node) {
        return SPRING_BEANS_NAMESPACE.equals(node.getNamespaceURI()) && "value".equals(node.getLocalName()) && node.getNodeType() == 1;
    }

    private boolean isInterfacesElement(Node node) {
        return SPRING_DM_NAMESPACE.equals(node.getNamespaceURI()) && ELEMENT_INTERFACES.equals(node.getLocalName()) && node.getNodeType() == 1;
    }

    private boolean isServiceElement(Node node) {
        return SPRING_DM_NAMESPACE.equals(node.getNamespaceURI()) && ELEMENT_SERVICE.equals(node.getLocalName()) && node.getNodeType() == 1;
    }

    private boolean isEntryElement(Node node) {
        return SPRING_BEANS_NAMESPACE.equals(node.getNamespaceURI()) && ELEMENT_ENTRY.equals(node.getLocalName()) && node.getNodeType() == 1;
    }
}

