/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.annotation;

import java.lang.annotation.Annotation;
import java.util.concurrent.Executor;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.scheduling.annotation.AsyncAnnotationAdvisor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncAnnotationBeanPostProcessor
extends ProxyConfig
implements BeanPostProcessor,
BeanClassLoaderAware,
InitializingBean,
Ordered {
    private Class<? extends Annotation> asyncAnnotationType;
    private Executor executor;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private AsyncAnnotationAdvisor asyncAnnotationAdvisor;

    public void setAsyncAnnotationType(Class<? extends Annotation> asyncAnnotationType) {
        Assert.notNull(asyncAnnotationType, (String)"'asyncAnnotationType' must not be null");
        this.asyncAnnotationType = asyncAnnotationType;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void afterPropertiesSet() {
        AsyncAnnotationAdvisor asyncAnnotationAdvisor = this.asyncAnnotationAdvisor = this.executor != null ? new AsyncAnnotationAdvisor(this.executor) : new AsyncAnnotationAdvisor();
        if (this.asyncAnnotationType != null) {
            this.asyncAnnotationAdvisor.setAsyncAnnotationType(this.asyncAnnotationType);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof AopInfrastructureBean) {
            return bean;
        }
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (AopUtils.canApply((Advisor)this.asyncAnnotationAdvisor, (Class)targetClass)) {
            if (bean instanceof Advised) {
                ((Advised)bean).addAdvisor(0, (Advisor)this.asyncAnnotationAdvisor);
                return bean;
            }
            ProxyFactory proxyFactory = new ProxyFactory(bean);
            proxyFactory.copyFrom((ProxyConfig)this);
            proxyFactory.addAdvisor((Advisor)this.asyncAnnotationAdvisor);
            return proxyFactory.getProxy(this.beanClassLoader);
        }
        return bean;
    }
}

