/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.InstanceProcess;
import org.eclipse.equinox.internal.ds.Messages;
import org.eclipse.equinox.internal.ds.impl.ComponentInstanceImpl;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentException;

final class FactoryReg
implements ServiceFactory {
    private final ServiceComponentProp component;

    FactoryReg(ServiceComponentProp component) {
        this.component = component;
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        try {
            ComponentInstanceImpl ci;
            if (Activator.DEBUG) {
                Activator.log.debug("FactoryReg.getService(): created new service for component " + this.component.name, null);
            }
            if ((ci = InstanceProcess.staticRef.buildComponent(bundle, this.component, null, false)) != null) {
                return ci.getInstance();
            }
        }
        catch (Throwable t) {
            if (!(t instanceof ComponentException)) {
                Activator.log(this.component.bc, 1, NLS.bind((String)Messages.CANT_GET_SERVICE, (Object)this.component.name), t);
            }
            throw (ComponentException)t;
        }
        return null;
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        if (Activator.DEBUG) {
            Activator.log.debug("FactoryReg.ungetService(): registration = " + registration.toString(), null);
        }
        this.component.disposeObj(service, 0);
    }

    public String toString() {
        return String.valueOf(this.component.name) + " FactoryRegistration";
    }
}

