/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.filesystem;

import java.io.File;
import org.apache.sshd.server.FileSystemView;
import org.apache.sshd.server.SshFile;
import org.apache.sshd.server.filesystem.NativeSshFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeFileSystemView
implements FileSystemView {
    private final Logger LOG = LoggerFactory.getLogger(NativeFileSystemView.class);
    private String currDir;
    private String userName;
    private boolean caseInsensitive = false;

    protected NativeFileSystemView(String userName) {
        this(userName, false);
    }

    public NativeFileSystemView(String userName, boolean caseInsensitive) {
        if (userName == null) {
            throw new IllegalArgumentException("user can not be null");
        }
        this.caseInsensitive = caseInsensitive;
        this.currDir = System.getProperty("user.dir");
        this.userName = userName;
        this.LOG.debug("Native filesystem view created for user \"{}\" with root \"{}\"", (Object)userName, (Object)this.currDir);
    }

    public SshFile getFile(String file) {
        String physicalName = NativeSshFile.getPhysicalName("/", this.currDir, file, this.caseInsensitive);
        File fileObj = new File(physicalName);
        String userFileName = physicalName.substring("/".length() - 1);
        return new NativeSshFile(userFileName, fileObj, this.userName);
    }
}

