/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.rewriters;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.surrogate.SurrogateQueryRegistry;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PBodyCopier;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PDisjunctionRewriter;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.RewriterException;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

public class SurrogateQueryRewriter
extends PDisjunctionRewriter {
    @Override
    public PDisjunction rewrite(PDisjunction disjunction) throws RewriterException {
        HashSet replacedBodies = Sets.newHashSet();
        for (PBody body : disjunction.getBodies()) {
            PBodyCopier copier = new PBodyCopier(body, this.getTraceCollector()){

                @Override
                protected void copyTypeConstraint(TypeConstraint typeConstraint) {
                    Object[] mappedVariables = this.extractMappedVariables(typeConstraint);
                    Tuple variablesTuple = Tuples.flatTupleOf(mappedVariables);
                    IInputKey supplierKey = (IInputKey)typeConstraint.getSupplierKey();
                    if (SurrogateQueryRegistry.instance().hasSurrogateQueryFQN(supplierKey)) {
                        PQuery surrogateQuery = SurrogateQueryRegistry.instance().getSurrogateQuery(supplierKey);
                        if (surrogateQuery == null) {
                            throw new IllegalStateException(String.format("Surrogate query for feature %s not found", supplierKey.getPrettyPrintableName()));
                        }
                        this.addTrace(typeConstraint, new PositivePatternCall(this.getCopiedBody(), variablesTuple, surrogateQuery));
                    } else {
                        this.addTrace(typeConstraint, new TypeConstraint(this.getCopiedBody(), variablesTuple, supplierKey));
                    }
                }
            };
            PBody modifiedBody = copier.getCopiedBody();
            replacedBodies.add(modifiedBody);
            modifiedBody.setStatus(PQuery.PQueryStatus.OK);
        }
        return new PDisjunction(replacedBodies);
    }
}

