/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.rewriters;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.planning.helpers.TypeHelper;
import org.eclipse.viatra.query.runtime.matchers.psystem.ITypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.ITypeInfoProviderConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.TypeJudgement;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.ConstraintRemovalReason;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PBodyCopier;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PDisjunctionRewriter;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.RewriterException;

public class PBodyNormalizer
extends PDisjunctionRewriter {
    public boolean calcImpliedTypes;
    private IQueryMetaContext context;

    public PBodyNormalizer(IQueryMetaContext context) {
        this.context = context;
        this.calcImpliedTypes = true;
    }

    public PBodyNormalizer(IQueryMetaContext context, boolean calculateImpliedTypes) {
        this.context = context;
        this.calcImpliedTypes = calculateImpliedTypes;
    }

    protected boolean shouldCalculateImpliedTypes(PQuery query) {
        return this.calcImpliedTypes;
    }

    protected boolean shouldExpandWeakenedAlternatives(PQuery query) {
        return false;
    }

    @Override
    public PDisjunction rewrite(PDisjunction disjunction) throws RewriterException {
        HashSet normalizedBodies = Sets.newHashSet();
        for (PBody body : disjunction.getBodies()) {
            PBodyCopier copier = new PBodyCopier(body, this.getTraceCollector());
            PBody modifiedBody = copier.getCopiedBody();
            this.normalizeBody(modifiedBody);
            normalizedBodies.add(modifiedBody);
            modifiedBody.setStatus(PQuery.PQueryStatus.OK);
        }
        return new PDisjunction(normalizedBodies);
    }

    public void setContext(IQueryMetaContext context) {
        this.context = context;
    }

    public PBody normalizeBody(PBody body) throws RewriterException {
        try {
            return this.normalizeBodyInternal(body);
        }
        catch (QueryProcessingException e) {
            throw new RewriterException("Error during rewriting: {1}", new String[]{e.getMessage()}, e.getShortMessage(), body.getPattern(), e);
        }
    }

    PBody normalizeBodyInternal(PBody body) throws QueryProcessingException {
        this.unifyVariablesAlongEqualities(body);
        this.eliminateWeakInequalities(body);
        this.removeMootEqualities(body);
        if (this.shouldExpandWeakenedAlternatives(body.getPattern())) {
            this.expandWeakenedAlternativeConstraints(body);
        }
        if (this.shouldCalculateImpliedTypes(body.getPattern())) {
            this.eliminateInferrableTypes(body, this.context);
        } else {
            this.eliminateDuplicateTypeConstraints(body);
        }
        this.checkSanity(body);
        return body;
    }

    private void removeMootEqualities(PBody body) {
        Set<Equality> equals = body.getConstraintsOfType(Equality.class);
        for (Equality equality : equals) {
            if (!equality.isMoot()) continue;
            equality.delete();
            this.derivativeRemoved(equality, ConstraintRemovalReason.MOOT_EQUALITY);
        }
    }

    void unifyVariablesAlongEqualities(PBody body) {
        Set<Equality> equals = body.getConstraintsOfType(Equality.class);
        for (Equality equality : equals) {
            if (equality.isMoot()) continue;
            equality.getWho().unifyInto(equality.getWithWhom());
        }
    }

    void eliminateWeakInequalities(PBody body) {
        for (Inequality inequality : body.getConstraintsOfType(Inequality.class)) {
            if (!inequality.isEliminable()) continue;
            inequality.eliminateWeak();
            this.derivativeRemoved(inequality, ConstraintRemovalReason.WEAK_INEQUALITY_SELF_LOOP);
        }
    }

    void eliminateInferrableTypes(PBody body, IQueryMetaContext context) {
        Set<TypeJudgement> subsumedByRetainedConstraints = new HashSet<TypeJudgement>();
        LinkedList<ITypeConstraint> allTypeConstraints = new LinkedList<ITypeConstraint>();
        for (PConstraint pConstraint : body.getConstraints()) {
            if (pConstraint instanceof ITypeConstraint) {
                allTypeConstraints.add((ITypeConstraint)pConstraint);
                continue;
            }
            if (!(pConstraint instanceof ITypeInfoProviderConstraint)) continue;
            Set<TypeJudgement> directJudgements = ((ITypeInfoProviderConstraint)pConstraint).getImpliedJudgements(context);
            subsumedByRetainedConstraints = TypeHelper.typeClosure(subsumedByRetainedConstraints, directJudgements, context);
        }
        Ordering eliminationOrder = Ordering.from(context.getSuggestedEliminationOrdering()).onResultOf((Function)new Function<ITypeConstraint, IInputKey>(){

            public IInputKey apply(ITypeConstraint input) {
                return input.getEquivalentJudgement().getInputKey();
            }
        }).compound((Comparator)PConstraint.CompareByMonotonousID.INSTANCE);
        Collections.sort(allTypeConstraints, eliminationOrder);
        LinkedList<ITypeConstraint> potentialConstraints = allTypeConstraints;
        while (!potentialConstraints.isEmpty()) {
            ITypeConstraint candidate = (ITypeConstraint)potentialConstraints.poll();
            boolean isSubsumed = subsumedByRetainedConstraints.contains(candidate.getEquivalentJudgement());
            if (!isSubsumed) {
                Set<TypeJudgement> typeClosure = subsumedByRetainedConstraints;
                for (ITypeConstraint subsuming : potentialConstraints) {
                    Set<TypeJudgement> directJudgements = subsuming.getImpliedJudgements(context);
                    if (!(typeClosure = TypeHelper.typeClosure(typeClosure, directJudgements, context)).contains(candidate.getEquivalentJudgement())) continue;
                    isSubsumed = true;
                    break;
                }
            }
            if (isSubsumed) {
                candidate.delete();
                this.derivativeRemoved(candidate, ConstraintRemovalReason.TYPE_SUBSUMED);
                continue;
            }
            subsumedByRetainedConstraints = TypeHelper.typeClosure(subsumedByRetainedConstraints, candidate.getImpliedJudgements(context), context);
        }
    }

    void expandWeakenedAlternativeConstraints(PBody body) {
        HashSet<TypeJudgement> allJudgements = new HashSet<TypeJudgement>();
        HashSet<TypeJudgement> newJudgementsToAdd = new HashSet<TypeJudgement>();
        LinkedList<TypeJudgement> judgementsToProcess = new LinkedList<TypeJudgement>();
        HashMultimap traceability = HashMultimap.create();
        for (ITypeConstraint typeConstraint : body.getConstraintsOfType(ITypeConstraint.class)) {
            TypeJudgement equivalentJudgement = typeConstraint.getEquivalentJudgement();
            judgementsToProcess.add(equivalentJudgement);
            allJudgements.add(equivalentJudgement);
            traceability.put((Object)equivalentJudgement, (Object)typeConstraint);
        }
        while (!judgementsToProcess.isEmpty()) {
            TypeJudgement judgement = (TypeJudgement)judgementsToProcess.poll();
            for (TypeJudgement alternativeJudgement : judgement.getWeakenedAlternativeJudgements(this.context)) {
                if (!allJudgements.add(alternativeJudgement)) continue;
                newJudgementsToAdd.add(alternativeJudgement);
                judgementsToProcess.add(alternativeJudgement);
                traceability.putAll((Object)alternativeJudgement, (Iterable)traceability.get((Object)judgement));
            }
        }
        for (TypeJudgement typeJudgement : newJudgementsToAdd) {
            PConstraint newConstraint = typeJudgement.createConstraintFor(body);
            for (PConstraint source : traceability.get((Object)typeJudgement)) {
                this.addTrace(source, newConstraint);
            }
        }
    }

    private Object getConstraintKey(PConstraint constraint) {
        if (constraint instanceof ITypeConstraint) {
            return ((ITypeConstraint)constraint).getEquivalentJudgement();
        }
        return constraint;
    }

    void eliminateDuplicateTypeConstraints(PBody body) {
        HashMap constraints = Maps.newHashMap();
        for (PConstraint constraint : body.getConstraints()) {
            Object key = this.getConstraintKey(constraint);
            if (constraints.containsKey(key)) continue;
            constraints.put(key, constraint);
        }
        Iterator<PConstraint> iterator = body.getConstraints().iterator();
        Collection toRetain = constraints.values();
        while (iterator.hasNext()) {
            PConstraint next = iterator.next();
            if (toRetain.contains(next)) continue;
            this.derivativeRemoved(next, ConstraintRemovalReason.DUPLICATE);
            iterator.remove();
        }
    }

    void checkSanity(PBody body) throws QueryProcessingException {
        for (PConstraint pConstraint : body.getConstraints()) {
            pConstraint.checkSanity();
        }
    }
}

