/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationInstance;
import org.eclipse.viatra.examples.cps.deployment.DeploymentApplication;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.queries.MappedApplicationInstanceMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.queries.MonitoredApplicationInstanceMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules.AbstractRule;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ApplicationUpdate
extends AbstractRule<MonitoredApplicationInstanceMatch> {
    public ApplicationUpdate(ViatraQueryEngine engine) {
        super(engine);
    }

    @Override
    public RuleSpecification<MonitoredApplicationInstanceMatch> getSpecification() {
        try {
            Job<MonitoredApplicationInstanceMatch> _appearedJob = this.getAppearedJob();
            Job<MonitoredApplicationInstanceMatch> _disappearedJob = this.getDisappearedJob();
            Job<MonitoredApplicationInstanceMatch> _updatedJob = this.getUpdatedJob();
            return Rules.newMatcherRuleSpecification((IQuerySpecification)this.cpsXformM2M.getMonitoredApplicationInstance(), (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Job[]{_appearedJob, _disappearedJob, _updatedJob})));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Job<MonitoredApplicationInstanceMatch> getAppearedJob() {
        IMatchProcessor<MonitoredApplicationInstanceMatch> _function = new IMatchProcessor<MonitoredApplicationInstanceMatch>(){

            public void process(MonitoredApplicationInstanceMatch match) {
                String appId = match.getAppInstance().getIdentifier();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Starting monitoring mapped application with ID: ");
                _builder.append((Object)appId);
                ApplicationUpdate.this.logger.debug((Object)_builder);
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function);
    }

    private Job<MonitoredApplicationInstanceMatch> getDisappearedJob() {
        IMatchProcessor<MonitoredApplicationInstanceMatch> _function = new IMatchProcessor<MonitoredApplicationInstanceMatch>(){

            public void process(MonitoredApplicationInstanceMatch match) {
                String appId = match.getAppInstance().getIdentifier();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Stopped monitoring mapped application with ID: ");
                _builder.append((Object)appId);
                ApplicationUpdate.this.logger.debug((Object)_builder);
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function);
    }

    private Job<MonitoredApplicationInstanceMatch> getUpdatedJob() {
        IMatchProcessor<MonitoredApplicationInstanceMatch> _function = new IMatchProcessor<MonitoredApplicationInstanceMatch>(){

            public void process(MonitoredApplicationInstanceMatch match) {
                try {
                    ApplicationInstance app = match.getAppInstance();
                    final String appId = app.getIdentifier();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Updating application with ID: ");
                    _builder.append((Object)appId);
                    ApplicationUpdate.this.logger.debug((Object)_builder);
                    Collection<MappedApplicationInstanceMatch> depAppMatches = ApplicationUpdate.this.cpsXformM2M.getMappedApplicationInstance(ApplicationUpdate.this.engine).getAllMatches(app, null, null, null);
                    Procedures.Procedure1<MappedApplicationInstanceMatch> _function = new Procedures.Procedure1<MappedApplicationInstanceMatch>(){

                        public void apply(MappedApplicationInstanceMatch it) {
                            boolean _contains;
                            boolean _not;
                            boolean _notEquals;
                            String depAppId = it.getDepApp().getId();
                            boolean bl = _notEquals = !Objects.equal((Object)appId, (Object)depAppId);
                            if (_notEquals) {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)"ID updated from ");
                                _builder.append((Object)appId);
                                _builder.append((Object)" to ");
                                _builder.append((Object)depAppId);
                                (this).ApplicationUpdate.this.logger.trace((Object)_builder);
                                DeploymentApplication _depApp = it.getDepApp();
                                _depApp.setId(appId);
                            }
                            boolean bl2 = _not = !(_contains = it.getDepHost().getApplications().contains((Object)it.getDepApp()));
                            if (_not) {
                                StringConcatenation _builder_1 = new StringConcatenation();
                                _builder_1.append((Object)"Host changed to ");
                                String _ip = it.getDepHost().getIp();
                                _builder_1.append((Object)_ip);
                                (this).ApplicationUpdate.this.logger.trace((Object)_builder_1);
                                EList _applications = it.getDepHost().getApplications();
                                DeploymentApplication _depApp_1 = it.getDepApp();
                                _applications.add((Object)_depApp_1);
                            }
                        }
                    };
                    IterableExtensions.forEach(depAppMatches, (Procedures.Procedure1)_function);
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append((Object)"Updated application with ID: ");
                    _builder_1.append((Object)appId);
                    ApplicationUpdate.this.logger.debug((Object)_builder_1);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function);
    }
}

