/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Identifiable;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Transition;
import org.eclipse.viatra.examples.cps.deployment.BehaviorState;
import org.eclipse.viatra.examples.cps.deployment.BehaviorTransition;
import org.eclipse.viatra.examples.cps.deployment.DeploymentApplication;
import org.eclipse.viatra.examples.cps.deployment.DeploymentElement;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.queries.TransitionMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules.AbstractRule;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.util.PriorityRuleSpecification;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class TransitionMapping
extends AbstractRule<TransitionMatch> {
    public TransitionMapping(ViatraQueryEngine engine) {
        super(engine);
    }

    @Override
    public PriorityRuleSpecification<TransitionMatch> getSpecification() {
        PriorityRuleSpecification _createPriorityRuleSpecification = this.createPriorityRuleSpecification();
        Procedures.Procedure1<PriorityRuleSpecification<TransitionMatch>> _function = new Procedures.Procedure1<PriorityRuleSpecification<TransitionMatch>>(){

            public void apply(PriorityRuleSpecification<TransitionMatch> it) {
                try {
                    Job _appearedJob = TransitionMapping.this.getAppearedJob();
                    Job _updateJob = TransitionMapping.this.getUpdateJob();
                    Job _disappearedJob = TransitionMapping.this.getDisappearedJob();
                    it.setRuleSpecification((RuleSpecification<TransitionMatch>)Rules.newMatcherRuleSpecification((IQuerySpecification)TransitionMapping.this.cpsXformM2M.getTransition(), (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Job[]{_appearedJob, _updateJob, _disappearedJob}))));
                    it.setPriority(5);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return (PriorityRuleSpecification)ObjectExtensions.operator_doubleArrow(_createPriorityRuleSpecification, (Procedures.Procedure1)_function);
    }

    private Job<TransitionMatch> getAppearedJob() {
        IMatchProcessor<TransitionMatch> _function = new IMatchProcessor<TransitionMatch>(){

            public void process(TransitionMatch match) {
                TransitionMapping.this.addTransition(match);
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function);
    }

    private void addTransition(TransitionMatch match) {
        try {
            DeploymentApplication depApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getAppInstance()), DeploymentApplication.class));
            final Transition transition = match.getTransition();
            final String transitionId = transition.getIdentifier();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Mapping transition with ID: ");
            _builder.append((Object)transitionId);
            this.logger.debug((Object)_builder);
            BehaviorTransition _createBehaviorTransition = this.depFactory.createBehaviorTransition();
            Procedures.Procedure1<BehaviorTransition> _function = new Procedures.Procedure1<BehaviorTransition>(){

                public void apply(BehaviorTransition it) {
                    it.setDescription(transitionId);
                }
            };
            final BehaviorTransition depTransition = (BehaviorTransition)ObjectExtensions.operator_doubleArrow((Object)_createBehaviorTransition, (Procedures.Procedure1)_function);
            EList _transitions = depApp.getBehavior().getTransitions();
            _transitions.add((Object)depTransition);
            final Set<DeploymentElement> tempDepSources = this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getSrcState());
            Functions.Function1<BehaviorState, Boolean> _function_1 = new Functions.Function1<BehaviorState, Boolean>(){

                public Boolean apply(BehaviorState it) {
                    return tempDepSources.contains(it);
                }
            };
            BehaviorState depSource = (BehaviorState)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getStates(), (Functions.Function1)_function_1);
            EList _outgoing = depSource.getOutgoing();
            _outgoing.add((Object)depTransition);
            final Set<DeploymentElement> tempDepTargets = this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getTransition().getTargetState());
            Functions.Function1<BehaviorState, Boolean> _function_2 = new Functions.Function1<BehaviorState, Boolean>(){

                public Boolean apply(BehaviorState it) {
                    return tempDepTargets.contains(it);
                }
            };
            BehaviorState depTarget = (BehaviorState)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getStates(), (Functions.Function1)_function_2);
            depTransition.setTo(depTarget);
            Set<CPS2DeploymentTrace> traces = this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOftrace(null, (Identifiable)transition, null);
            boolean _isEmpty = traces.isEmpty();
            if (_isEmpty) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"Creating new trace for transition ");
                this.logger.trace((Object)_builder_1);
                EList _traces = this.getRootMapping().getTraces();
                CPS2DeploymentTrace _createCPS2DeploymentTrace = this.traceFactory.createCPS2DeploymentTrace();
                Procedures.Procedure1<CPS2DeploymentTrace> _function_3 = new Procedures.Procedure1<CPS2DeploymentTrace>(){

                    public void apply(CPS2DeploymentTrace it) {
                        EList _cpsElements = it.getCpsElements();
                        _cpsElements.add((Object)transition);
                        EList _deploymentElements = it.getDeploymentElements();
                        _deploymentElements.add((Object)depTransition);
                    }
                };
                CPS2DeploymentTrace _doubleArrow = (CPS2DeploymentTrace)ObjectExtensions.operator_doubleArrow((Object)_createCPS2DeploymentTrace, (Procedures.Procedure1)_function_3);
                _traces.add((Object)_doubleArrow);
            } else {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append((Object)"Adding new transition to existing trace");
                this.logger.trace((Object)_builder_2);
                EList _deploymentElements = ((CPS2DeploymentTrace)IterableExtensions.head(traces)).getDeploymentElements();
                _deploymentElements.add((Object)depTransition);
            }
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append((Object)"Mapped transition with ID: ");
            _builder_3.append((Object)transitionId);
            this.logger.debug((Object)_builder_3);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Job<TransitionMatch> getUpdateJob() {
        IMatchProcessor<TransitionMatch> _function = new IMatchProcessor<TransitionMatch>(){

            public void process(TransitionMatch match) {
                try {
                    BehaviorState _to;
                    boolean _notEquals_1;
                    boolean _not;
                    boolean _notEquals;
                    Transition transition = match.getTransition();
                    String trId = transition.getIdentifier();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Updating mapped transition with ID: ");
                    _builder.append((Object)trId);
                    TransitionMapping.this.logger.debug((Object)_builder);
                    DeploymentApplication depApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(TransitionMapping.this.cpsXformM2M.getCps2depTrace(TransitionMapping.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getAppInstance()), DeploymentApplication.class));
                    final Set depTransitions = IterableExtensions.toSet((Iterable)Iterables.filter(TransitionMapping.this.cpsXformM2M.getCps2depTrace(TransitionMapping.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)transition), BehaviorTransition.class));
                    Functions.Function1<BehaviorTransition, Boolean> _function = new Functions.Function1<BehaviorTransition, Boolean>(){

                        public Boolean apply(BehaviorTransition it) {
                            return depTransitions.contains(it);
                        }
                    };
                    BehaviorTransition depTransition = (BehaviorTransition)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getTransitions(), (Functions.Function1)_function);
                    String oldDesc = depTransition.getDescription();
                    boolean bl = _notEquals = !Objects.equal((Object)oldDesc, (Object)trId);
                    if (_notEquals) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append((Object)"ID changed to ");
                        _builder_1.append((Object)oldDesc);
                        TransitionMapping.this.logger.trace((Object)_builder_1);
                        depTransition.setDescription(trId);
                    }
                    final Set<DeploymentElement> tempDepSources = TransitionMapping.this.cpsXformM2M.getCps2depTrace(TransitionMapping.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getSrcState());
                    Functions.Function1<BehaviorState, Boolean> _function_1 = new Functions.Function1<BehaviorState, Boolean>(){

                        public Boolean apply(BehaviorState it) {
                            return tempDepSources.contains(it);
                        }
                    };
                    BehaviorState depSource = (BehaviorState)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getStates(), (Functions.Function1)_function_1);
                    final Set<DeploymentElement> tempDepTargets = TransitionMapping.this.cpsXformM2M.getCps2depTrace(TransitionMapping.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getTransition().getTargetState());
                    Functions.Function1<BehaviorState, Boolean> _function_2 = new Functions.Function1<BehaviorState, Boolean>(){

                        public Boolean apply(BehaviorState it) {
                            return tempDepTargets.contains(it);
                        }
                    };
                    BehaviorState depTarget = (BehaviorState)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getStates(), (Functions.Function1)_function_2);
                    boolean _contains = depSource.getOutgoing().contains((Object)depTransition);
                    boolean bl2 = _not = !_contains;
                    if (_not) {
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append((Object)"Source state changed to ");
                        String _description = depSource.getDescription();
                        _builder_2.append((Object)_description);
                        TransitionMapping.this.logger.trace((Object)_builder_2);
                        EList _outgoing = depSource.getOutgoing();
                        _outgoing.add((Object)depTransition);
                    }
                    boolean bl3 = _notEquals_1 = !Objects.equal((Object)(_to = depTransition.getTo()), (Object)depTarget);
                    if (_notEquals_1) {
                        StringConcatenation _builder_3 = new StringConcatenation();
                        _builder_3.append((Object)"Target state changed to ");
                        String _description_1 = depTarget.getDescription();
                        _builder_3.append((Object)_description_1);
                        TransitionMapping.this.logger.trace((Object)_builder_3);
                        depTransition.setTo(depTarget);
                    }
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append((Object)"Updated mapped transition with ID: ");
                    _builder_4.append((Object)trId);
                    TransitionMapping.this.logger.debug((Object)_builder_4);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function);
    }

    private Job<TransitionMatch> getDisappearedJob() {
        IMatchProcessor<TransitionMatch> _function = new IMatchProcessor<TransitionMatch>(){

            public void process(TransitionMatch match) {
                TransitionMapping.this.deleteTransition(match);
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function);
    }

    private void deleteTransition(TransitionMatch match) {
        try {
            Transition transition = match.getTransition();
            DeploymentApplication depApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getAppInstance()), DeploymentApplication.class));
            final Set depTransitions = IterableExtensions.toSet((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)transition), BehaviorTransition.class));
            Functions.Function1<BehaviorTransition, Boolean> _function = new Functions.Function1<BehaviorTransition, Boolean>(){

                public Boolean apply(BehaviorTransition it) {
                    return depTransitions.contains(it);
                }
            };
            BehaviorTransition depTransition = (BehaviorTransition)IterableExtensions.findFirst(this.cpsXformM2M.getDepBehaviorsStateAndTransitions(this.engine).getAllValuesOfdepTransition(depApp.getBehavior(), null), (Functions.Function1)_function);
            String trId = depTransition.getDescription();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Removing transition with ID: ");
            _builder.append((Object)trId);
            this.logger.debug((Object)_builder);
            depTransition.setTo(null);
            final Set<DeploymentElement> tempDepSources = this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getSrcState());
            Functions.Function1<BehaviorState, Boolean> _function_1 = new Functions.Function1<BehaviorState, Boolean>(){

                public Boolean apply(BehaviorState it) {
                    return tempDepSources.contains(it);
                }
            };
            BehaviorState depSource = (BehaviorState)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getStates(), (Functions.Function1)_function_1);
            EList _outgoing = null;
            if (depSource != null) {
                _outgoing = depSource.getOutgoing();
            }
            _outgoing.remove((Object)depTransition);
            EList _transitions = depApp.getBehavior().getTransitions();
            _transitions.remove((Object)depTransition);
            CPS2DeploymentTrace smTrace = (CPS2DeploymentTrace)IterableExtensions.head(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOftrace(null, (Identifiable)transition, null));
            EList _deploymentElements = smTrace.getDeploymentElements();
            _deploymentElements.remove((Object)depTransition);
            boolean _isEmpty = smTrace.getDeploymentElements().isEmpty();
            if (_isEmpty) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"Removing empty trace");
                this.logger.trace((Object)_builder_1);
                EList _traces = this.getRootMapping().getTraces();
                _traces.remove((Object)smTrace);
            }
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)"Removed transition with ID: ");
            _builder_2.append((Object)trId);
            this.logger.debug((Object)_builder_2);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

