/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules;

import com.google.common.base.Objects;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Identifiable;
import org.eclipse.viatra.examples.cps.deployment.DeploymentElement;
import org.eclipse.viatra.examples.cps.deployment.DeploymentHost;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.queries.Cps2depTraceMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.queries.HostInstanceMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules.AbstractRule;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.util.PriorityRuleSpecification;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class HostMapping
extends AbstractRule<HostInstanceMatch> {
    public HostMapping(ViatraQueryEngine engine) {
        super(engine);
    }

    @Override
    public PriorityRuleSpecification<HostInstanceMatch> getSpecification() {
        PriorityRuleSpecification _createPriorityRuleSpecification = this.createPriorityRuleSpecification();
        Procedures.Procedure1<PriorityRuleSpecification<HostInstanceMatch>> _function = new Procedures.Procedure1<PriorityRuleSpecification<HostInstanceMatch>>(){

            public void apply(PriorityRuleSpecification<HostInstanceMatch> it) {
                try {
                    Job _appearedJob = HostMapping.this.getAppearedJob();
                    Job _updateJob = HostMapping.this.getUpdateJob();
                    Job _disappearedJob = HostMapping.this.getDisappearedJob();
                    it.setRuleSpecification((RuleSpecification<HostInstanceMatch>)Rules.newMatcherRuleSpecification((IQuerySpecification)HostMapping.this.cpsXformM2M.getHostInstance(), (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Job[]{_appearedJob, _updateJob, _disappearedJob}))));
                    it.setPriority(1);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return (PriorityRuleSpecification)ObjectExtensions.operator_doubleArrow(_createPriorityRuleSpecification, (Procedures.Procedure1)_function);
    }

    private Job<HostInstanceMatch> getAppearedJob() {
        IMatchProcessor<HostInstanceMatch> _function = new IMatchProcessor<HostInstanceMatch>(){

            public void process(final HostInstanceMatch match) {
                final String nodeIp = match.getHostInstance().getNodeIp();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Mapping host with IP: ");
                _builder.append((Object)nodeIp);
                HostMapping.this.logger.debug((Object)_builder);
                DeploymentHost _createDeploymentHost = HostMapping.this.depFactory.createDeploymentHost();
                Procedures.Procedure1<DeploymentHost> _function = new Procedures.Procedure1<DeploymentHost>(){

                    public void apply(DeploymentHost it) {
                        it.setIp(nodeIp);
                    }
                };
                final DeploymentHost host = (DeploymentHost)ObjectExtensions.operator_doubleArrow((Object)_createDeploymentHost, (Procedures.Procedure1)_function);
                EList _hosts = HostMapping.this.getRootMapping().getDeployment().getHosts();
                _hosts.add((Object)host);
                EList _traces = HostMapping.this.getRootMapping().getTraces();
                CPS2DeploymentTrace _createCPS2DeploymentTrace = HostMapping.this.traceFactory.createCPS2DeploymentTrace();
                Procedures.Procedure1<CPS2DeploymentTrace> _function_1 = new Procedures.Procedure1<CPS2DeploymentTrace>(){

                    public void apply(CPS2DeploymentTrace it) {
                        EList _cpsElements = it.getCpsElements();
                        HostInstance _hostInstance = match.getHostInstance();
                        _cpsElements.add((Object)_hostInstance);
                        EList _deploymentElements = it.getDeploymentElements();
                        _deploymentElements.add((Object)host);
                    }
                };
                CPS2DeploymentTrace _doubleArrow = (CPS2DeploymentTrace)ObjectExtensions.operator_doubleArrow((Object)_createCPS2DeploymentTrace, (Procedures.Procedure1)_function_1);
                _traces.add((Object)_doubleArrow);
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"Mapped host with IP: ");
                _builder_1.append((Object)nodeIp);
                HostMapping.this.logger.debug((Object)_builder_1);
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function);
    }

    private Job<HostInstanceMatch> getUpdateJob() {
        IMatchProcessor<HostInstanceMatch> _function = new IMatchProcessor<HostInstanceMatch>(){

            public void process(HostInstanceMatch match) {
                try {
                    boolean _notEquals;
                    DeploymentElement _depElement = HostMapping.this.cpsXformM2M.getCps2depTrace(HostMapping.this.engine).getOneArbitraryMatch(HostMapping.this.getRootMapping(), null, (Identifiable)match.getHostInstance(), null).getDepElement();
                    DeploymentHost depHost = (DeploymentHost)_depElement;
                    String hostIp = depHost.getIp();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Updating mapped host with IP: ");
                    _builder.append((Object)hostIp);
                    HostMapping.this.logger.debug((Object)_builder);
                    String nodeIp = match.getHostInstance().getNodeIp();
                    boolean bl = _notEquals = !Objects.equal((Object)nodeIp, (Object)hostIp);
                    if (_notEquals) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append((Object)"IP changed to ");
                        _builder_1.append((Object)nodeIp);
                        HostMapping.this.logger.trace((Object)_builder_1);
                        depHost.setIp(nodeIp);
                    }
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append((Object)"Updated mapped host with IP: ");
                    _builder_2.append((Object)nodeIp);
                    HostMapping.this.logger.debug((Object)_builder_2);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function);
    }

    private Job<HostInstanceMatch> getDisappearedJob() {
        IMatchProcessor<HostInstanceMatch> _function = new IMatchProcessor<HostInstanceMatch>(){

            public void process(HostInstanceMatch match) {
                try {
                    Cps2depTraceMatch traceMatch = HostMapping.this.cpsXformM2M.getCps2depTrace(HostMapping.this.engine).getOneArbitraryMatch(HostMapping.this.getRootMapping(), null, (Identifiable)match.getHostInstance(), null);
                    String hostIp = match.getHostInstance().getNodeIp();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Removing host with IP: ");
                    _builder.append((Object)hostIp);
                    HostMapping.this.logger.debug((Object)_builder);
                    EList _hosts = HostMapping.this.getRootMapping().getDeployment().getHosts();
                    DeploymentElement _depElement = traceMatch.getDepElement();
                    _hosts.remove((Object)((DeploymentHost)_depElement));
                    EList _traces = HostMapping.this.getRootMapping().getTraces();
                    CPS2DeploymentTrace _trace = traceMatch.getTrace();
                    _traces.remove((Object)_trace);
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append((Object)"Removed host with IP: ");
                    _builder_1.append((Object)hostIp);
                    HostMapping.this.logger.debug((Object)_builder_1);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function);
    }
}

