/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules;

import com.google.common.base.Preconditions;
import org.apache.log4j.Logger;
import org.eclipse.viatra.examples.cps.deployment.DeploymentFactory;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.traceability.TraceabilityFactory;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.queries.CpsXformM2M;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.queries.MappedCPSMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.queries.MappedCPSMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.util.PriorityRuleSpecification;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;

public abstract class AbstractRule<M extends IPatternMatch> {
    @Extension
    protected Logger logger = Logger.getLogger((String)"cps.xform.AbstractRule");
    @Extension
    protected DeploymentFactory depFactory = DeploymentFactory.eINSTANCE;
    @Extension
    protected TraceabilityFactory traceFactory = TraceabilityFactory.eINSTANCE;
    @Extension
    protected CpsXformM2M cpsXformM2M = new Functions.Function0<CpsXformM2M>(){

        public CpsXformM2M apply() {
            try {
                CpsXformM2M _instance = CpsXformM2M.instance();
                return _instance;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }.apply();
    protected ViatraQueryEngine engine;

    public AbstractRule(ViatraQueryEngine engine) {
        this.engine = engine;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Creating rule ");
        String _simpleName = this.getClass().getSimpleName();
        _builder.append((Object)_simpleName);
        this.logger.debug((Object)_builder);
    }

    public abstract PriorityRuleSpecification<M> getSpecification();

    public CPSToDeployment getRootMapping() {
        try {
            MappedCPSMatcher matcher = this.cpsXformM2M.getMappedCPS(this.engine);
            int _countMatches = matcher.countMatches();
            boolean _equals = _countMatches == 1;
            Preconditions.checkState((boolean)_equals, (Object)"Incorrect number of CPSToDeployment mappings!");
            return ((MappedCPSMatch)matcher.getOneArbitraryMatch()).getCps2dep();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public <Match extends M> PriorityRuleSpecification<Match> createPriorityRuleSpecification() {
        return new PriorityRuleSpecification();
    }
}

