/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.groups;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.groups.GroupLaunchConfigurationDelegate;
import org.eclipse.debug.internal.core.groups.GroupLaunchElement;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.groups.GroupLaunchConfigurationTabGroup;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationFilteredTree;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PatternFilter;

class GroupLaunchConfigurationSelectionDialog
extends TitleAreaDialog
implements ISelectionChangedListener {
    private static final String GROUP_TYPE_ID = "org.eclipse.debug.core.groups.GroupLaunchConfigurationType";
    private ISelection fSelection;
    private String mode;
    private GroupLaunchElement.GroupElementPostLaunchAction action = GroupLaunchElement.GroupElementPostLaunchAction.NONE;
    private Object actionParam;
    private boolean adoptIfRunning;
    private ViewerFilter emptyTypeFilter;
    private IStructuredSelection fInitialSelection;
    private Label fActionParamLabel;
    private Text fActionParamWidget;
    private boolean fForEditing;
    private ILaunchConfigurationType groupType;
    private ILaunchConfiguration selfRef;

    public GroupLaunchConfigurationSelectionDialog(Shell shell, String initMode, boolean forEditing, final ILaunchConfiguration self) {
        super(shell);
        this.mode = initMode;
        this.fForEditing = forEditing;
        this.selfRef = self;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.groupType = this.getLaunchManager().getLaunchConfigurationType(GROUP_TYPE_ID);
        this.emptyTypeFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                block6: {
                    ILaunchConfiguration c;
                    block8: {
                        block7: {
                            try {
                                if (element instanceof ILaunchConfigurationType) {
                                    ILaunchConfigurationType type = (ILaunchConfigurationType)element;
                                    if (type.equals(GroupLaunchConfigurationSelectionDialog.this.groupType)) {
                                        return GroupLaunchConfigurationSelectionDialog.this.getLaunchManager().getLaunchConfigurations(type).length > 1;
                                    }
                                    return GroupLaunchConfigurationSelectionDialog.this.getLaunchManager().getLaunchConfigurations(type).length > 0;
                                }
                                if (!(element instanceof ILaunchConfiguration)) break block6;
                                c = (ILaunchConfiguration)element;
                                if (!c.getName().equals(self.getName()) || !c.getType().equals(GroupLaunchConfigurationSelectionDialog.this.groupType)) break block7;
                                return false;
                            }
                            catch (CoreException coreException) {
                                return false;
                            }
                        }
                        if (!c.getAttribute("org.eclipse.debug.ui.private", false)) break block8;
                        return false;
                    }
                    return GroupLaunchConfigurationTabGroup.isValidLaunchReference(c);
                }
                return true;
            }
        };
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected Control createContents(Composite parent) {
        Control x = super.createContents(parent);
        this.validate();
        this.setErrorMessage(null);
        return x;
    }

    protected Control createDialogArea(Composite parent2) {
        ViewerFilter[] filters;
        ILaunchGroup launchGroup2;
        Composite comp = (Composite)super.createDialogArea(parent2);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(comp);
        this.getShell().setText(this.fForEditing ? DebugUIMessages.GroupLaunchConfigurationSelectionDialog_13 : DebugUIMessages.GroupLaunchConfigurationSelectionDialog_12);
        this.setTitle(this.fForEditing ? DebugUIMessages.GroupLaunchConfigurationSelectionDialog_15 : DebugUIMessages.GroupLaunchConfigurationSelectionDialog_14);
        LinkedHashMap<String, ILaunchGroup> modes = new LinkedHashMap<String, ILaunchGroup>();
        modes.put(GroupLaunchElement.MODE_INHERIT, new InheritModeGroup());
        TreeSet<ILaunchGroup> sortedGroups = new TreeSet<ILaunchGroup>((a, b) -> a.getLabel().compareTo(b.getLabel()));
        LaunchConfigurationManager mgr = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        sortedGroups.addAll(Arrays.asList(mgr.getLaunchGroups()));
        for (ILaunchGroup launchGroup2 : sortedGroups) {
            LaunchHistory history = mgr.getLaunchHistory(launchGroup2.getIdentifier());
            if (history == null) continue;
            String label = launchGroup2.getLabel();
            if (modes.containsKey(label = DebugUIPlugin.removeAccelerators(label))) continue;
            modes.put(label, launchGroup2);
        }
        launchGroup2 = (ILaunchGroup)modes.get(GroupLaunchElement.MODE_INHERIT);
        LaunchConfigurationFilteredTree fTree = new LaunchConfigurationFilteredTree(comp, 2818, new PatternFilter(), launchGroup2, null);
        fTree.createViewControl();
        ViewerFilter[] viewerFilterArray = filters = fTree.getViewer().getFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter viewerFilter = viewerFilterArray[n2];
            if (viewerFilter instanceof LaunchGroupFilter) {
                fTree.getViewer().removeFilter(viewerFilter);
            }
            ++n2;
        }
        fTree.getViewer().addFilter(this.emptyTypeFilter);
        fTree.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.fInitialSelection != null) {
            fTree.getViewer().setSelection((ISelection)this.fInitialSelection, true);
        }
        GridDataFactory.fillDefaults().grab(true, true).hint(this.convertWidthInCharsToPixels(100), this.convertHeightInCharsToPixels(15)).applyTo(fTree.getViewer().getControl());
        Composite additionalSettings = new Composite(comp, 0);
        additionalSettings.setLayout((Layout)new GridLayout(4, false));
        additionalSettings.setLayoutData((Object)new GridData(768));
        this.createModeSelectionControl(modes, additionalSettings);
        this.createPostLaunchControl(additionalSettings);
        Composite c = new Composite(additionalSettings, 0);
        GridLayoutFactory.fillDefaults().applyTo(c);
        GridDataFactory.fillDefaults().applyTo((Control)c);
        final Button chkAdopt = new Button(additionalSettings, 32);
        chkAdopt.setText(DebugUIMessages.GroupLaunchConfigurationSelectionDialog_adoptText);
        chkAdopt.setToolTipText(DebugUIMessages.GroupLaunchConfigurationSelectionDialog_adoptTooltip);
        chkAdopt.setSelection(this.adoptIfRunning);
        chkAdopt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupLaunchConfigurationSelectionDialog.this.adoptIfRunning = chkAdopt.getSelection();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)chkAdopt);
        return comp;
    }

    private void createModeSelectionControl(Map<String, ILaunchGroup> modes, Composite comp) {
        Label label = new Label(comp, 0);
        label.setText(DebugUIMessages.GroupLaunchConfigurationSelectionDialog_4);
        final LinkedHashMap capitalized = new LinkedHashMap();
        modes.keySet().forEach(m -> {
            String string = capitalized.put(String.valueOf(m.substring(0, 1).toUpperCase()) + m.substring(1), m);
        });
        final Combo cvMode = new Combo(comp, 8);
        GridDataFactory.fillDefaults().applyTo((Control)cvMode);
        cvMode.setItems(capitalized.keySet().toArray(new String[capitalized.size()]));
        int index = 0;
        for (String m2 : modes.keySet()) {
            if (m2.equals(this.mode)) {
                cvMode.select(index);
                break;
            }
            ++index;
        }
        cvMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupLaunchConfigurationSelectionDialog.this.mode = (String)capitalized.get(cvMode.getText());
                GroupLaunchConfigurationSelectionDialog.this.validate();
            }
        });
        Composite c = new Composite(comp, 0);
        GridLayoutFactory.fillDefaults().applyTo(c);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)c);
    }

    private void createPostLaunchControl(Composite comp) {
        Label label = new Label(comp, 0);
        label.setText(DebugUIMessages.GroupLaunchConfigurationSelectionDialog_8);
        Combo combo = new Combo(comp, 8);
        combo.add(GroupLaunchElement.GroupElementPostLaunchAction.NONE.getDescription());
        combo.add(GroupLaunchElement.GroupElementPostLaunchAction.WAIT_FOR_TERMINATION.getDescription());
        combo.add(GroupLaunchElement.GroupElementPostLaunchAction.DELAY.getDescription());
        combo.add(GroupLaunchElement.GroupElementPostLaunchAction.OUTPUT_REGEXP.getDescription());
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String actionStr = ((Combo)e.widget).getText();
                GroupLaunchConfigurationSelectionDialog.this.action = GroupLaunchElement.GroupElementPostLaunchAction.valueOfDescription((String)actionStr);
                GroupLaunchConfigurationSelectionDialog.this.showHideDelayAmountWidgets();
                GroupLaunchConfigurationSelectionDialog.this.validate();
            }
        });
        combo.setText(this.action.getDescription());
        GridDataFactory.fillDefaults().applyTo((Control)combo);
        this.fActionParamLabel = new Label(comp, 0);
        this.fActionParamWidget = new Text(comp, 2052);
        GridDataFactory.fillDefaults().applyTo((Control)this.fActionParamWidget);
        this.fActionParamWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                if (GroupLaunchConfigurationSelectionDialog.this.action == GroupLaunchElement.GroupElementPostLaunchAction.DELAY) {
                    try {
                        GroupLaunchConfigurationSelectionDialog.this.actionParam = Integer.valueOf(text);
                    }
                    catch (NumberFormatException numberFormatException) {
                        GroupLaunchConfigurationSelectionDialog.this.actionParam = null;
                    }
                } else if (GroupLaunchConfigurationSelectionDialog.this.action == GroupLaunchElement.GroupElementPostLaunchAction.OUTPUT_REGEXP) {
                    GroupLaunchConfigurationSelectionDialog.this.actionParam = text;
                }
                GroupLaunchConfigurationSelectionDialog.this.validate();
            }
        });
        if (this.actionParam instanceof Integer) {
            this.fActionParamWidget.setText(((Integer)this.actionParam).toString());
        } else if (this.actionParam instanceof String) {
            this.fActionParamWidget.setText(this.actionParam.toString());
        }
        this.showHideDelayAmountWidgets();
    }

    private void showHideDelayAmountWidgets() {
        boolean visible = this.action == GroupLaunchElement.GroupElementPostLaunchAction.DELAY || this.action == GroupLaunchElement.GroupElementPostLaunchAction.OUTPUT_REGEXP;
        this.fActionParamLabel.setVisible(visible);
        this.fActionParamWidget.setVisible(visible);
        if (this.action == GroupLaunchElement.GroupElementPostLaunchAction.DELAY) {
            this.fActionParamLabel.setText(DebugUIMessages.GroupLaunchConfigurationSelectionDialog_9);
        } else if (this.action == GroupLaunchElement.GroupElementPostLaunchAction.OUTPUT_REGEXP) {
            this.fActionParamLabel.setText(DebugUIMessages.GroupLaunchConfigurationSelectionDialog_regexp);
        }
        this.fActionParamLabel.getParent().layout();
    }

    public ILaunchConfiguration[] getSelectedLaunchConfigurations() {
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        if (this.fSelection != null && !this.fSelection.isEmpty()) {
            for (Object selection : (IStructuredSelection)this.fSelection) {
                if (!(selection instanceof ILaunchConfiguration)) continue;
                configs.add((ILaunchConfiguration)selection);
            }
        }
        return configs.toArray(new ILaunchConfiguration[configs.size()]);
    }

    public String getMode() {
        return this.mode;
    }

    public GroupLaunchElement.GroupElementPostLaunchAction getAction() {
        return this.action;
    }

    public boolean getAdoptIfRunning() {
        return this.adoptIfRunning;
    }

    public Object getActionParam() {
        return this.actionParam;
    }

    public static GroupLaunchConfigurationSelectionDialog createDialog(Shell shell, String initMode, boolean forEditing, ILaunchConfiguration self) {
        return new GroupLaunchConfigurationSelectionDialog(shell, initMode, forEditing, self);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fSelection = event.getSelection();
        this.validate();
    }

    protected void validate() {
        Button ok_button = this.getButton(0);
        boolean isValid = true;
        if (this.getSelectedLaunchConfigurations().length < 1) {
            this.setErrorMessage(DebugUIMessages.GroupLaunchConfigurationSelectionDialog_7);
            isValid = false;
        } else {
            this.setErrorMessage(null);
        }
        if (isValid && this.fForEditing && this.getSelectedLaunchConfigurations().length > 1) {
            this.setErrorMessage(DebugUIMessages.GroupLaunchConfigurationSelectionDialog_11);
            isValid = false;
        }
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = this.getSelectedLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration sel = iLaunchConfigurationArray[n2];
                if (isValid && sel.getType().equals(this.groupType)) {
                    isValid = !this.hasSelfRecursive(sel);
                    this.setErrorMessage(isValid ? null : DebugUIMessages.GroupLaunchConfigurationSelectionDialog_0);
                }
                if (isValid && !GroupLaunchElement.MODE_INHERIT.equals(this.mode)) {
                    if (!sel.supportsMode(this.mode)) {
                        isValid = false;
                    }
                    this.setErrorMessage(isValid ? null : DebugUIMessages.GroupLaunchConfigurationSelectionDialog_1);
                }
                if (isValid) {
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        if (isValid) {
            if (this.action == GroupLaunchElement.GroupElementPostLaunchAction.DELAY) {
                isValid = this.actionParam instanceof Integer && (Integer)this.actionParam > 0;
                this.setErrorMessage(isValid ? null : DebugUIMessages.GroupLaunchConfigurationSelectionDialog_10);
            }
            if (this.action == GroupLaunchElement.GroupElementPostLaunchAction.OUTPUT_REGEXP) {
                boolean bl = isValid = this.actionParam instanceof String && !((String)this.actionParam).isEmpty();
                if (isValid) {
                    try {
                        Pattern.compile((String)this.actionParam);
                    }
                    catch (Exception exception) {
                        isValid = false;
                    }
                }
                this.setErrorMessage(isValid ? null : DebugUIMessages.GroupLaunchConfigurationSelectionDialog_errorNoRegexp);
            }
        }
        if (ok_button != null) {
            ok_button.setEnabled(isValid);
        }
    }

    private boolean hasSelfRecursive(ILaunchConfiguration c) throws CoreException {
        if (c == null) {
            return false;
        }
        if (c.getType().equals(this.groupType)) {
            if (c.getName().equals(this.selfRef.getName())) {
                return true;
            }
            for (GroupLaunchElement e : GroupLaunchConfigurationDelegate.createLaunchElements((ILaunchConfiguration)c)) {
                if (!this.hasSelfRecursive(e.data)) continue;
                return true;
            }
        }
        return false;
    }

    public void setInitialSelection(GroupLaunchElement el) {
        this.action = el.action;
        this.actionParam = el.actionParam;
        this.adoptIfRunning = el.adoptIfRunning;
        this.fInitialSelection = new StructuredSelection((Object)el.data);
        this.fSelection = this.fInitialSelection;
    }

    private static final class InheritModeGroup
    implements ILaunchGroup {
        private InheritModeGroup() {
        }

        @Override
        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        @Override
        public ImageDescriptor getBannerImageDescriptor() {
            return null;
        }

        @Override
        public String getLabel() {
            return null;
        }

        @Override
        public String getIdentifier() {
            return null;
        }

        @Override
        public String getCategory() {
            return null;
        }

        @Override
        public String getMode() {
            return null;
        }

        @Override
        public boolean isPublic() {
            return false;
        }
    }
}

