/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.views.core;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.api.GenericPatternMatch;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.transformation.evm.api.ExecutionSchema;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.event.ActivationState;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.viatra.transformation.views.traceablilty.generic.AbstractQuerySpecificationDescriptor;
import org.eclipse.viatra.transformation.views.traceablilty.generic.GenericReferencedQuerySpecification;
import org.eclipse.viatra.transformation.views.traceablilty.generic.GenericTracedQuerySpecification;

public abstract class ViewModelRule {
    private EventFilter<IPatternMatch> filter;
    private boolean isFilterInitialized = false;
    private AbstractQuerySpecificationDescriptor descriptor;
    protected Logger logger = Logger.getLogger(ViewModelRule.class);

    public ViewModelRule(AbstractQuerySpecificationDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public GenericTracedQuerySpecification getTracedSpecification() {
        return this.descriptor.getTracedSpecification();
    }

    public GenericReferencedQuerySpecification getReferencedSpecification() {
        return this.getTracedSpecification().getReferencedSpecification();
    }

    public IQuerySpecification<?> getBaseSpecification() {
        return this.getReferencedSpecification().getBaseSpecification();
    }

    protected Job<GenericPatternMatch> getAppearedJob() {
        return Jobs.newNopJob((ActivationState)CRUDActivationStateEnum.CREATED);
    }

    protected Job<GenericPatternMatch> getDisappearedJob() {
        return Jobs.newNopJob((ActivationState)CRUDActivationStateEnum.DELETED);
    }

    protected Job<GenericPatternMatch> getUpdatedJob() {
        return Jobs.newNopJob((ActivationState)CRUDActivationStateEnum.UPDATED);
    }

    public final void createRuleSpecification(ExecutionSchema executionSchema) {
        if (!this.isFilterInitialized) {
            this.filter = this.prepareFilterSuper();
        }
        this.registerReferencedSpecification(executionSchema);
        this.registerTraceabilitySpecification(executionSchema);
    }

    private void registerReferencedSpecification(ExecutionSchema executionSchema) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add(this.getAppearedJob());
        builder.add((Object)Jobs.newNopJob((ActivationState)CRUDActivationStateEnum.DELETED));
        builder.add((Object)Jobs.newNopJob((ActivationState)CRUDActivationStateEnum.UPDATED));
        RuleSpecification ruleSpecification = Rules.newMatcherRuleSpecification((IQuerySpecification)this.getReferencedSpecification(), (Set)builder.build());
        if (this.isFiltered()) {
            executionSchema.addRule(ruleSpecification, this.filter);
        } else {
            executionSchema.addRule(ruleSpecification);
        }
    }

    private void registerTraceabilitySpecification(ExecutionSchema executionSchema) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)Jobs.newNopJob((ActivationState)CRUDActivationStateEnum.CREATED));
        builder.add(this.getDisappearedJob());
        builder.add(this.getUpdatedJob());
        RuleSpecification ruleSpecification = Rules.newMatcherRuleSpecification((IQuerySpecification)this.getTracedSpecification(), (Set)builder.build());
        executionSchema.addRule(ruleSpecification);
    }

    private EventFilter<IPatternMatch> prepareFilterSuper() {
        this.isFilterInitialized = true;
        return this.prepareFilter();
    }

    protected abstract EventFilter<IPatternMatch> prepareFilter();

    public void setFilter(EventFilter<IPatternMatch> filter) {
        this.filter = filter;
    }

    public EventFilter<IPatternMatch> getFilter() {
        return this.filter;
    }

    public boolean isFiltered() {
        return this.filter != null;
    }

    public final void initialize(String traceabilityId) throws QueryInitializationException {
        this.descriptor.initialize(traceabilityId);
        this.filter = this.prepareFilter();
    }
}

