/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.viatra.query.runtime.localsearch.planner.PConstraintCategory;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.IConstraintEvaluationContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryBackendContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryResultProviderAccess;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.analysis.QueryAnalyzer;

public class PConstraintInfo
implements IConstraintEvaluationContext {
    private PConstraint constraint;
    private Set<PVariable> boundMaskVariables;
    private Set<PVariable> freeMaskVariables;
    private Set<PConstraintInfo> sameWithDifferentBindings;
    private IQueryRuntimeContext runtimeContext;
    private QueryAnalyzer queryAnalyzer;
    private IQueryResultProviderAccess resultProviderAccess;
    private double cost;

    public PConstraintInfo(PConstraint constraint, Set<PVariable> boundMaskVariables, Set<PVariable> freeMaskVariables, Set<PConstraintInfo> sameWithDifferentBindings, IQueryBackendContext context, Function<IConstraintEvaluationContext, Double> costFunction) {
        this.constraint = constraint;
        this.boundMaskVariables = boundMaskVariables;
        this.freeMaskVariables = freeMaskVariables;
        this.sameWithDifferentBindings = sameWithDifferentBindings;
        this.runtimeContext = context.getRuntimeContext();
        this.queryAnalyzer = context.getQueryAnalyzer();
        this.resultProviderAccess = context.getResultProviderAccess();
        this.cost = (Double)costFunction.apply((Object)this);
    }

    @Override
    public IQueryRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public QueryAnalyzer getQueryAnalyzer() {
        return this.queryAnalyzer;
    }

    @Override
    public PConstraint getConstraint() {
        return this.constraint;
    }

    public Set<PVariable> getFreeVariables() {
        return this.freeMaskVariables;
    }

    public Set<PVariable> getBoundVariables() {
        return this.boundMaskVariables;
    }

    public Set<PConstraintInfo> getSameWithDifferentBindings() {
        return this.sameWithDifferentBindings;
    }

    public double getCost() {
        return this.cost;
    }

    public PConstraintCategory getCategory(PBody pBody, Set<PVariable> boundVariables) {
        if (!Sets.intersection(this.freeMaskVariables, boundVariables).isEmpty()) {
            return PConstraintCategory.PAST;
        }
        if (!Sets.intersection(this.boundMaskVariables, (Set)Sets.difference((Set)pBody.getAllVariables(), boundVariables)).isEmpty()) {
            return PConstraintCategory.FUTURE;
        }
        return PConstraintCategory.PRESENT;
    }

    public String toString() {
        return String.format("%s, bound variables: %s, cost: \"%.2f\"", this.constraint.toString(), this.boundMaskVariables.toString(), this.cost);
    }

    @Override
    public IQueryResultProviderAccess resultProviderAccess() {
        return this.resultProviderAccess;
    }
}

